/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.jira;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.sal.usercompatibility.UserKey;
import com.atlassian.sal.usercompatibility.UserManager;
import com.atlassian.upm.SysCommon;
import com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class GlobalPermissionUserCountCacheImpl
implements GlobalPermissionUserCountCache {
    private static final String CONNECT_ADDONS_GROUP = "atlassian-addons";
    private final GlobalPermissionManager globalPermissionManager;
    private final Cache<GlobalPermissionKey, Integer> permissionCountCache;
    private final UserManager userManager;

    public GlobalPermissionUserCountCacheImpl(GlobalPermissionManager globalPermissionManager, CrowdService crowdService, CacheManager cacheManager, UserManager userManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.userManager = userManager;
        this.permissionCountCache = cacheManager.getCache("com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache", (CacheLoader)new GlobalPermissionUserCountCacheLoader(crowdService), new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build());
    }

    @Override
    public void resetAll() {
        this.permissionCountCache.removeAll();
    }

    @Override
    public void reset(GlobalPermissionKey globalPermissionKey) {
        this.permissionCountCache.remove((Object)globalPermissionKey);
    }

    @Override
    public int getUserCount(GlobalPermissionKey globalPermissionKey) {
        return (Integer)this.permissionCountCache.get((Object)globalPermissionKey);
    }

    private class GlobalPermissionUserCountCacheLoader
    implements CacheLoader<GlobalPermissionKey, Integer> {
        private final CrowdService crowdService;

        public GlobalPermissionUserCountCacheLoader(CrowdService crowdService) {
            this.crowdService = crowdService;
        }

        private Iterable<User> getGroupMembers(String groupName) {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
            return this.crowdService.search((Query)membershipQuery);
        }

        public Integer load(@NotNull GlobalPermissionKey permissionKey) {
            Collection groupsWithUsePermission = GlobalPermissionUserCountCacheImpl.this.globalPermissionManager.getGroupNamesWithPermission(permissionKey);
            HashSet<User> allUsers = new HashSet<User>();
            for (String groupName : groupsWithUsePermission) {
                Iterable<User> users = this.getGroupMembers(groupName);
                for (User user : users) {
                    ApplicationUser appUser = ApplicationUsers.from((User)user);
                    if (!user.isActive() || !this.hasUsePermission(appUser) || !this.isNotSysAdminInOnDemand(appUser)) continue;
                    allUsers.add(user);
                }
            }
            if (SysCommon.isOnDemand()) {
                ImmutableSet connectAddonUsers = ImmutableSet.copyOf(this.getGroupMembers(GlobalPermissionUserCountCacheImpl.CONNECT_ADDONS_GROUP));
                return Sets.difference(allUsers, (Set)connectAddonUsers).size();
            }
            return allUsers.size();
        }

        private boolean hasUsePermission(final ApplicationUser user) {
            return Iterables.any((Iterable)GlobalPermissionType.getUsePermissions(), (Predicate)new Predicate<String>(){

                public boolean apply(String permission) {
                    return GlobalPermissionUserCountCacheImpl.this.globalPermissionManager.hasPermission(GlobalPermissionKey.of((String)permission), user);
                }
            });
        }

        private boolean isNotSysAdminInOnDemand(ApplicationUser user) {
            return !SysCommon.isOnDemand() || !GlobalPermissionUserCountCacheImpl.this.userManager.isSystemAdmin(new UserKey(user.getKey()));
        }
    }
}

