
define('jira/project-templates/template-info-controller', [
    'jira/project-templates/template-info-view',
    'jira/lib/class',
    'require',
    'underscore'
], function(
    TemplateInfoView,
    Class,
    require,
    _
){
    var TemplateInfoController = Class.extend({

        init: function(options) {
            _.bindAll(this, "initTemplateInfo", "next");
        },

        initTemplateInfo: function(projectTemplateData) {
            this.projectTemplateData = projectTemplateData;

            var infoView = new TemplateInfoView();
            infoView.draw(projectTemplateData.infoSoyPath, projectTemplateData.name);
        },

        next: function() {
            var SelectProjectTemplateController = require('jira/project-templates/select-project-template-controller');
            SelectProjectTemplateController.openAddProjectPage(this.projectTemplateData);
        }
    });
    return new TemplateInfoController();
});
AJS.namespace('JPT.TemplateInfoControllerImpl', null, require('jira/project-templates/template-info-controller'));