// Warning!
// This module has a hidden circular dependency -> jira/project-templates/select-project-template-controller
define('jira/project-templates/select-project-template-view', [
    'jira/project-templates/dialog-controller',
    'jira/project-templates/config',
    'jira/featureflags/feature-manager',
    'require',
    'backbone',
    'jquery',
    'underscore'
], function(
    DialogController,
    Config,
    featureManager,
    require,
    Backbone,
    $,
    _
){
    var contextPath = AJS.contextPath();
    var preventDefault = AJS.preventDefault;

    return {
        ROW_LENGTH: 2,
        DIALOG_BODY_CLASS: "select-project-templates-page",
        DIALOG_WIDTH: 800,

        draw: function(data, projectType) {
            var SelectProjectTemplateController = require('jira/project-templates/select-project-template-controller');
            this.page = DialogController.addPage({
                name: this.DIALOG_BODY_CLASS,
                title: data.demoProjects ? AJS.I18n.getText("add.project.select.demo.template.title") : AJS.I18n.getText("add.project.select.template.title"),
                panelName: "ProjectTemplatesListPanel",
                backButton: false,
                submitButtonText: AJS.I18n.getText("add.project.next"),
                submitButtonCallback: SelectProjectTemplateController.dialogSubmitted,
                submitButtonClass: "create-project-dialog-create-button"
            });

            function getHtml() {
                if (SelectProjectTemplateController.isProjectTypesEnabled(data)) {
                    return JIRA.Templates.ProjectTemplates.renderProjectTemplatesGroupedByType({
                        projectTemplatesByType: data.projectTemplatesGroupedByType
                    });
                }
                return JIRA.Templates.ProjectTemplates.renderProjectTemplates({
                    projectTemplates: data.projectTemplates
                });
            }

            DialogController.dialog.getPanel(this.page.id, 0).html(getHtml());

            if (Config.model.projectCount >= 2 && !data.demoProjects) {
                $(JIRA.Templates.ProjectTemplates.addWorkflowsLink({
                    baseUrl : contextPath
                })).appendTo(DialogController.$dialogElement.find(".dialog-title"));
            }

            var $nextButton = DialogController.$dialogElement.find(".create-project-dialog-create-button");
            var self = this;
            this.getTemplateItems().click(function() {
                var $this = $(this);
                $this.addClass("selected");
                self.getTemplateItems().not(this).removeClass("selected");
            }).dblclick(function() {
                $nextButton.click();
            }).focus(function () {
                $(this).click();
            });

            var $templatesContainer = this.get$TemplatesContainer();

            if (!data.demoProjects) {
                $(JIRA.Templates.ProjectTemplates.footerLinks({
                    showDemoLink: featureManager.isFeatureEnabled("jira.onboarding.cyoa")
                }))
                        .prependTo(DialogController.$dialogElement.find(".dialog-button-panel"));
            }

            this.bindKeyboardEvents($templatesContainer);

            if(SelectProjectTemplateController.isProjectTypesEnabled(data)) {
                if((data.projectTemplatesGroupedByType).length == 0) $nextButton.attr("disabled", "disabled");
            } else {
                if((data.projectTemplates).length == 0) $nextButton.attr("disabled", "disabled");
            }

            this.focusOnFirstTemplate($templatesContainer, projectType);

            DialogController.dialog.updateHeight();
            this.truncateTemplateDescriptions();
            this.resizeTemplateWidths();
        },

        get$TemplatesContainer: function() {
            return DialogController.$dialogElement.find('.templates');
        },

        focusOnFirstTemplate: function($templatesContainer, projectType) {
            if (projectType) {
                this.getFirstTemplateItemOfProjectType(projectType).click();
            } else {
                this.getFirstTemplateItem().click();
            }
            // Make sure me don't loose the focus because of any other interactions
            setTimeout(function (){
                $templatesContainer.focus();
            }, 0);
        },

        getSelectedTemplateData: function() {
            var $selectedTemplate = DialogController.$dialogElement.find(".template.selected");

            return $selectedTemplate.data();
        },

        /**
         * Converts arrow directions into sibling movement amounts in a grid.
         * @param which - the code of the key pressed
         * @return {Number} the amount to move, or 0 if no move should occur for this key code
         */
        getMoveDeltaForKey: function (which) {
            switch (which) {
                case 37: return -1; // left
                case 39: return +1; // right
                case 38: return -this.ROW_LENGTH; // up
                case 40: return +this.ROW_LENGTH; // down
            }
            return 0;
        },

        /**
         * Key-bindings on arrow-keys to change the selected template in the template container.
         */
        bindKeyboardEvents: function ($container) {
            $container.bind("keydown", _.bind(function (e) {
                var delta = this.getMoveDeltaForKey(e.which);
                if (delta) {
                    this.moveSelection($container, delta);
                    return preventDefault(e);
                }
            }, this));
        },

        /**
         * Move the selection in the template container forward or backward by a specified number of templates
         * @param container the template container jQuery object
         * @param delta - positive to move forward, negative to move backward
         */
        moveSelection: function (container, delta) {
            var $results = container.find('.template');
            var $selected = $results.filter('.selected');
            var index = $results.index($selected) + delta;
            if (index < $results.length && index >= 0) {
                var $next = $results.eq(index);
                $next.click().focus();

                this.scrollToSelectedElement($next);
            }
        },

        scrollToSelectedElement: function($selected) {
            var $itemContainer = $(".dialog-panel-body.pt-content");
            var itemContainerTopPosition = $itemContainer.offset().top;
            var nextTopPosition = $selected.offset().top;
            var nextBottomPosition = nextTopPosition + $selected.height();
            var itemContainerBottomPosition = itemContainerTopPosition + $itemContainer.height();

            if (nextTopPosition < itemContainerTopPosition) {
                $itemContainer.scrollTop($itemContainer.scrollTop() - (itemContainerTopPosition - nextTopPosition));
            } else if(nextBottomPosition > (itemContainerTopPosition + $itemContainer.height())) {
                $itemContainer.scrollTop($itemContainer.scrollTop() + nextBottomPosition - itemContainerBottomPosition);
            }
        },

        get$NextButton: function() {
            return DialogController.$dialogElement.find(".create-project-dialog-create-button");
        },

        disableNextButton: function() {
            this.get$NextButton().attr('disabled','disabled');
        },

        truncateTemplateDescriptions: function() {
            var locale = AJS.Meta.get("user-locale");
            var wrap = "word";
            if (locale === "ja_JP") {
                wrap = "letter";
            }
            DialogController.$dialogElement.find(".template-description").each(function() {
                $(this).dotdotdot({
                    'wrap': wrap,
                    'lastCharacter': {
                        'remove'		: [ ' ', ',', ';', '.', '!', '?', '。' ],
                        'noEllipsis'	: []
                    }
                });
            });
        },

        getTemplatesDialogContainer: function() {
            return DialogController.$dialogElement
                    .find("." + this.DIALOG_BODY_CLASS)
                    .find(".dialog-panel-body.pt-content")
                    .get(0);
        },

        getFirstTemplateItem: function() {
            return this.getTemplateItems().first();
        },

        getFirstTemplateItemOfProjectType: function(projectType) {
            return this.getTemplateItems().filter("#project-template-group-" + projectType + " *").first();
        },

        getTemplateItems: function() {
            return DialogController.$dialogElement.find(".template");
        },

        widthOfScrollbarForElement: function(el) {
            var visibleWidth = el.offsetWidth;
            var visibleWidthWithoutBorders = el.clientWidth;

            return visibleWidth - visibleWidthWithoutBorders;
        },

        widthOfDialogAvailableForTemplateList: function() {
            var dialogScrollbarWidth = this.widthOfScrollbarForElement(this.getTemplatesDialogContainer());

            return this.DIALOG_WIDTH - dialogScrollbarWidth;
        },

        widthOfTemplateItem: function() {
            var maxWidthForEachItem = this.widthOfDialogAvailableForTemplateList() / this.ROW_LENGTH;

            return maxWidthForEachItem - this.borderWidthOfTemplateItem();
        },

        borderWidthOfTemplateItem: function() {
            var templateItemBorderWidthString = this.getFirstTemplateItem().css("border-top-width");

            return parseInt(templateItemBorderWidthString, 10);
        },

        resizeTemplateWidths: function() {
            this.getTemplateItems().each(_.bind(function(index, el) {
                $(el).css("width", this.widthOfTemplateItem());
            }, this));
        }
    };
});
AJS.namespace('JPT.SelectProjectTemplateView', null, require('jira/project-templates/select-project-template-view'));