// Warning!
// This module has a hidden circular dependencies -> jira/project-templates/select-project-template-controller
//                                                -> jira/project-templates/create-shared-controller
define('jira/project-templates/dialog-controller', [
    'jira/project-templates/dialog-view',
    'jira/project-templates/config',
    'jira/ajs/ajax/smart-ajax',
    'jira/util/data/meta',
    'jira/lib/class',
    'jquery',
    'underscore',
    'wrm/data'
], function(
    DialogView,
    Config,
    SmartAjax,
    Meta,
    Class,
    $,
    _,
    wrmData
){
    var contextPath = AJS.contextPath();
    var isDevMode = AJS.isDevMode;
    var log = AJS.log;

    function triggerAnalytics(name, params) {
        AJS.trigger('analyticsEvent', {name: name, data: params});
    }

    var ptAnalyticsData;
    var getPtAnalyticsData = function () {
        if( !ptAnalyticsData ) {
            ptAnalyticsData = wrmData.claim('com.atlassian.jira.project-templates-plugin:project-templates-plugin-resources.ptAnalyticsData') || {};
        }
        return ptAnalyticsData;
    };

    var DialogController = Class.extend({
        WELCOME_REST_URL: contextPath + "/rest/welcome/1.0/show/welcome",

        initialize: function() {
            _.bindAll(this, 'handleProjectTemplateTriggered', 'hideDialogFromNewUser');

            if (Meta.getBoolean('show-welcome-screen')) {
                this.handleProjectTemplateTriggered();
            }
        },

        handleProjectTemplateTriggered: function() {
            this.demoProject = false;
            triggerAnalytics('jira.project.templates.dialog.create.show');
            this.openWithFirstProjectTemplateOfTypePreSelected();
        },

        handleDemoProjectTemplateTriggered: function() {
            this.demoProject = true;
            var projectTemplatesDeferred = this.getTemplateController().loadDemoProjectTemplatesData();
            this.openWithFirstProjectTemplateOfTypePreSelected(null, projectTemplatesDeferred);
            this._addAnalyticsToCreateDemoShow(projectTemplatesDeferred);
        },

        _addAnalyticsToCreateDemoShow: function (projectTemplatesDeferred) {
            projectTemplatesDeferred.done(function (data) {
                var params = {};

                var getDemoSets = function (data) {
                    return data.projectTemplatesGroupedByType.map(
                        function (ptGroup) {
                            return ptGroup.projectTemplates.map(
                                function (pt) {
                                    return pt.itemModuleCompleteKey
                                }).join();
                        }).join();
                };

                params.demoSets = getDemoSets(data);
                params.instanceCreatedDate = getPtAnalyticsData().instanceCreatedDate;

                triggerAnalytics('jira.project.templates.dialog.create.demo.show', params);
            }.bind(this));
        },

        openWithFirstProjectTemplateOfTypePreSelected: function(projectTypeKey, projectTemplatesDeferred) {
            projectTemplatesDeferred = projectTemplatesDeferred || this.getTemplateController().loadProjectTemplatesData();
            //draw dialog with spinner
            this.dialog  = DialogView.draw();

            projectTemplatesDeferred.fail(_.bind(function (jqXHR) {
                this._handleUnknownErrorOfPTRetrieval();
            }, this));

            projectTemplatesDeferred.done(_.bind(function (data) {
                this.$dialogElement = this.dialog.popup.element;

                // Persist the selected template (e.g. after coming back from a GH installation)
                var selectedTemplate;
                if (!_.isUndefined(Config.model.selectedTemplate)) {
                    selectedTemplate = Config.model.selectedTemplate;
                }
                Config.model = data;
                Config.model.selectedTemplate = selectedTemplate;
                this.getTemplateController().init(data, projectTypeKey);
            }, this));
        },

        handleCreateShared: function() {
            triggerAnalytics('jira.project.templates.dialog.create.shared.clicked');
            this.demoProject = false;
            this.openWithCreateShared();
        },

        openWithCreateShared: function() {
            var CreateSharedController = require('jira/project-templates/create-shared-controller');
            CreateSharedController.initCreateShared();
        },

        callbackWithResize: function(callback) {
            return _.bind(_.wrap(callback, function(originalCallback) {
                originalCallback.call(this);
                this.dialog.updateHeight();
            }), this);
        },

        addPage: function(pageConfig) {
            var page = this.dialog.addPage(pageConfig.name).page[this.dialog.curpage];
            this.dialog.addHeader(pageConfig.title, "add-project-dialog-header");
            this.dialog.addPanel(pageConfig.panelName, "", "pt-content");

            if (pageConfig.backButton) {
                this._addBackButton(page);
            }

            this.dialog.addButton(
                pageConfig.submitButtonText,
                this.callbackWithResize(pageConfig.submitButtonCallback),
                pageConfig.submitButtonClass + " pt-submit-button"
            );
            var $submitButton = this.$dialogElement.find("." + pageConfig.submitButtonClass);
            $submitButton.removeClass("button-panel-button").addClass("aui-button aui-button-primary"); /* button-panel-button class doesn't have disabled styles, using .aui-button instead */
            $submitButton.focus();

            this.dialog.addCancel(AJS.I18n.getText("add.project.cancel"), _.bind(function(event) {
                this.hideDialogFromNewUser("dismissed");

                this.dialog.remove();
            }, this));

            return page;
        },

        _backButtonOnClickCallback: function(page) {
            return _.bind(function() {
                if (this.demoProject) {
                    triggerAnalytics("jira.project.templates.dialog.demo.back");
                } else {
                    triggerAnalytics("jira.project.templates.dialog.create.back");
                }
                var $addProjectWrapper = DialogView.get$PTContent();
                $addProjectWrapper.css('background-image', 'none');

                this.dialog.prevPage();
                page.remove();
                this.dialog.page.pop();
            }, this);
        },

        _addBackButton: function(page) {
            this.dialog.addButton(
                AJS.I18n.getText("admin.addproject.back"),
                this.callbackWithResize(this._backButtonOnClickCallback(page)),
                "add-project-back-button"
            );
            var $backButton = this.$dialogElement.find(".add-project-back-button");
            $backButton.removeClass("button-panel-button").addClass("aui-button");
        },

        _handleUnknownErrorOfPTRetrieval: function() {
            DialogView.showErrorMessage(AJS.I18n.getText("add.projects.templates.error.requestfailed.msg"));
        },

        hideDialogFromNewUser: function(reason) {
            if (reason === "dismissed") {
                if (this.demoProject) {
                    triggerAnalytics("jira.project.templates.dialog.demo.dismissed");
                } else {
                    triggerAnalytics("jira.project.templates.dialog.create.dismissed");
                }
            } else if (reason === "importproject") {
                triggerAnalytics('jira.project.templates.dialog.import.clicked');
            } else if (reason === "templateselected") {
                if (this.demoProject) {
                    triggerAnalytics("jira.project.templates.dialog.demo.templateselected");
                } else {
                    triggerAnalytics("jira.project.templates.dialog.create.templateselected");
                }
            }

            if (Meta.getBoolean('show-welcome-screen')) {
                $.ajax({
                    url: this.WELCOME_REST_URL + "/" + reason,
                    type: "DELETE",
                    success: function () {
                        if (isDevMode && isDevMode()) {
                            log("don't show project template dialog anymore");
                        }
                    }
                });
            }
        },

        getTemplateController: function() {
            return require('jira/project-templates/select-project-template-controller');
        }
    });

    return new DialogController();
});
AJS.namespace('JPT.DialogController', null, require('jira/project-templates/dialog-controller'));