// Warning!
// This module has a hidden circular dependency -> jira/project-templates/create-shared-controller
define('jira/project-templates/create-shared-view', [
    'jira/project-templates/dialog-controller',
    'jira/project-templates/dialog-view',
    'jira/ajs/select/scrollable-single-select',
    'jira/ajs/select/suggestion-collection-model',
    'require',
    'backbone',
    'jquery'
], function(
    DialogController,
    DialogView,
    ScrollableSingleSelect,
    SuggestionCollectionModel,
    require,
    Backbone,
    $
){
    "use strict";

    var InlineDialog = AJS.InlineDialog;
    var trigger = AJS.trigger;

    var CreateSharedView = Backbone.View.extend({
        events: {
            "submit #create-shared-project-form": "onSubmitForm"
        },

        page: undefined,

        /**
         * Prepare the Dialog to hold the Create Shared Project form; this should only be called once.
         */
        prepareDialog: function(title) {
            var CreateSharedController = require('jira/project-templates/create-shared-controller');
            this.page = DialogController.addPage({
                name: "create-shared-project",
                title: title,
                panelName: "create-shared-project",
                backButton: true,
                submitButtonText: AJS.I18n.getText("add.project.next"),
                submitButtonCallback: CreateSharedController.dialogSubmitted,
                submitButtonClass: "create-shared-dialog-button"
            });
        },

        /**
         * Draw the Add Project form into the passed dialog, as a new screen.
         *
         * This will be triggered on clicking "Next", so should render on the second page.
         */
        draw: function(params) {
            DialogController.dialog.gotoPage(this.page.id);

            var createSharedForm = JIRA.Templates.ProjectTemplates.createSharedProjectForm({
                "projectSuggestions": JSON.stringify(params.projectSuggestions)
            });

            DialogController.dialog.getPanel(this.page.id, 0).html(createSharedForm);

            this._createProjectPicker();

            var $sharedHelpElement = DialogController.$dialogElement.find("#shared-help-icon");
            if ($sharedHelpElement.length) {
                new InlineDialog($sharedHelpElement, "shared-project-help-popup",
                        function(contents, trigger, show) {
                            contents.html(JIRA.Templates.ProjectTemplates.sharedHelp());
                            show();
                        }, {
                            width: 330,
                            offsetX: -30
                        });
            }

            DialogController.$dialogElement.find(".dialog-button-panel button").removeAttr("disabled");
        },

        showProjectMissingError: function () {
            this._clearFormErrors();

            this._getProjectPickerInput().after(aui.form.fieldError({
                extraClasses: 'project-picker-missing-error',
                message: AJS.I18n.getText('add.project.dialog.create.shared.no.project.selected')
            }));
        },

        drawEmptyInfo: function() {
            var noProjects = JIRA.Templates.ProjectTemplates.noProjects();
            DialogController.dialog.getPanel(this.page.id, 0).html(noProjects);

            DialogController.$dialogElement.find(".dialog-button-panel button").hide();
        },

        drawError: function(message) {
            DialogController.dialog.getPanel(this.page.id, 0).html(JIRA.Templates.errorMsg({
                closable: false,
                msg: message
            }));
        },

        drawLoading: function() {
            DialogController.dialog.gotoPage(this.page.id);

            var addProjectForm = JIRA.Templates.ProjectTemplates.loading();

            DialogController.dialog.getPanel(this.page.id, 0).html(addProjectForm);

            DialogController.$dialogElement.find(".dialog-spinner").spin();
            DialogController.$dialogElement.find(".dialog-button-panel button").attr("disabled", "disabled");
        },

        _clearFormErrors: function() {
            DialogController.$dialogElement.find(".project-picker-missing-error").remove();
        },

        _getProjectPickerInput: function() {
            return DialogController.$dialogElement.find("#project-picker");
        },

        onSubmitForm: function(e) {
            this._clearFormErrors();
            var CreateSharedController = require('jira/project-templates/create-shared-controller');
            CreateSharedController.dialogSubmitted();
            return false;
        },

        _getExtraInfoMessage: function() {
            return DialogController.$dialogElement.find(".create-shared-info");
        },

        _createProjectPicker: function() {
            this._getExtraInfoMessage().hide();
            this.projectSelect = new ScrollableSingleSelect({
                element: this._getProjectPickerInput(),
                revertOnInvalid: true,
                pageSize: 50,
                pagingThreshold: 100,
                model: SuggestionCollectionModel
            });

            this.projectSelect.$field.focus();

            var self = this;
            this._getProjectPickerInput().on("selected", function(e, selected) {
                if(selected.value()) {
                    trigger('analyticsEvent', {name: 'jira.project.templates.dialog.create.shared.project.selected'});
                    self._getExtraInfoMessage().show();
                }
            });
        },

        getSelectedProject: function() {
            return this.projectSelect.getSelectedDescriptor() && this.projectSelect.getSelectedDescriptor().value();
        }
    });

    return new CreateSharedView({
        el: $(document),
        dialogView: DialogView
    });
});
AJS.namespace('JPT.CreateSharedView', null, require('jira/project-templates/create-shared-view'));
