/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.blueprint.api.ApiAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.ProjectTemplate;
import com.atlassian.jira.project.template.ProjectTemplateKey;
import com.atlassian.jira.project.template.ProjectTemplateManager;
import com.atlassian.jira.project.template.hook.AddProjectHook;
import com.atlassian.jira.project.template.hook.ValidateData;
import com.atlassian.jira.project.template.hook.ValidateResponse;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.projecttemplates.model.ApplicationInfoBean;
import com.atlassian.jira.projecttemplates.model.ApplyTemplateParam;
import com.atlassian.jira.projecttemplates.model.ProjectCreationResult;
import com.atlassian.jira.projecttemplates.model.ProjectCreationResultFactory;
import com.atlassian.jira.projecttemplates.model.ProjectTypeToTemplates;
import com.atlassian.jira.projecttemplates.querydsl.AppliedTemplate;
import com.atlassian.jira.projecttemplates.rest.ProjectTemplateBean;
import com.atlassian.jira.projecttemplates.service.AppliedTemplateStorage;
import com.atlassian.jira.projecttemplates.service.ProjectLicenseService;
import com.atlassian.jira.projecttemplates.service.ProjectTemplateService;
import com.atlassian.jira.projecttemplates.service.TemplateInstantiationFailure;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.ValidationFailureException;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ProjectTemplateServiceImpl
implements ProjectTemplateService {
    private final ProjectTemplateManager projectTemplateManager;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final ProjectService projectService;
    private final PermissionManager permissionManager;
    private final ProjectTypeManager projectTypeManager;
    private final ProjectCreationResultFactory resultFactory;
    private final ProjectLicenseService projectLicenseService;
    private AppliedTemplateStorage appliedTemplateStorage;
    private FeatureManager featureManager;

    public ProjectTemplateServiceImpl(I18nResolver i18nResolver, ProjectService projectService, PermissionManager permissionManager, ProjectTemplateManager projectTemplateManager, UserManager userManager, ProjectTypeManager projectTypeManager, ProjectCreationResultFactory resultFactory, ProjectLicenseService projectLicenseService, AppliedTemplateStorage appliedTemplateStorage, FeatureManager featureManager) {
        this.i18nResolver = i18nResolver;
        this.projectService = projectService;
        this.permissionManager = permissionManager;
        this.projectTemplateManager = projectTemplateManager;
        this.userManager = userManager;
        this.projectTypeManager = projectTypeManager;
        this.resultFactory = resultFactory;
        this.projectLicenseService = projectLicenseService;
        this.appliedTemplateStorage = appliedTemplateStorage;
        this.featureManager = featureManager;
    }

    @Override
    public List<ProjectTemplateBean> getProjectTemplateItems(ApplicationUser user) {
        return Lists.transform((List)this.projectTemplateManager.getProjectTemplates(), (Function)new Function<ProjectTemplate, ProjectTemplateBean>(){

            public ProjectTemplateBean apply(@Nullable ProjectTemplate template) {
                return new ProjectTemplateBean(template);
            }
        });
    }

    @Override
    public List<ProjectTypeToTemplates> getProjectTemplatesGroupedByType(ApplicationUser user) {
        ArrayList projectTypeToTemplates = Lists.newArrayList();
        ListMultimap<String, ProjectTemplateBean> typeToTemplates = this.getProjectTemplatesGroupedByProjectType(user);
        for (ProjectType projectType : this.getAccessibleProjectTypes()) {
            String projectTypeKey = projectType.getKey().getKey();
            if (!typeToTemplates.containsKey((Object)projectTypeKey)) continue;
            projectTypeToTemplates.add(new ProjectTypeToTemplates(projectType, typeToTemplates.get((Object)projectTypeKey), this.generateApplicationInfoForProject(projectType, user)));
        }
        return projectTypeToTemplates;
    }

    @Override
    public ApplicationInfoBean generateApplicationInfoForProjectKey(ProjectTypeKey projectTypeKey, ApplicationUser user) {
        return new ApplicationInfoBean(this.projectLicenseService.getLicenseTotalSeats(projectTypeKey), this.projectLicenseService.getLicenseUsedSeats(projectTypeKey), this.featureManager.isOnDemand(), this.projectLicenseService.userCanUseApplication(projectTypeKey, user), this.projectLicenseService.userCanBeAddedToApplication(user, projectTypeKey, user), this.projectLicenseService.getApplicationName(projectTypeKey));
    }

    public ApplicationInfoBean generateApplicationInfoForProject(ProjectType projectType, ApplicationUser user) {
        return this.generateApplicationInfoForProjectKey(projectType.getKey(), user);
    }

    @Override
    public List<ProjectType> getAccessibleProjectTypes() {
        return this.projectTypeManager.getAllProjectTypes().stream().filter(projectType -> this.projectTypeManager.getAccessibleProjectType(projectType.getKey()).isDefined()).collect(Collectors.toList());
    }

    private ListMultimap<String, ProjectTemplateBean> getProjectTemplatesGroupedByProjectType(ApplicationUser user) {
        ArrayListMultimap projectTemplatesByType = ArrayListMultimap.create();
        for (ProjectTemplate template : this.projectTemplateManager.getProjectTemplates()) {
            projectTemplatesByType.put((Object)template.getProjectTypeKey().getKey(), (Object)new ProjectTemplateBean(template));
        }
        return projectTemplatesByType;
    }

    @Override
    public ProjectCreationResult applyProjectTemplate(ApplyTemplateParam applyTemplateParam) throws TemplateInstantiationFailure, ValidationFailureException {
        ProjectTemplateKey templateKey = new ProjectTemplateKey(applyTemplateParam.getProjectTemplateWebItemKey());
        Optional result = this.projectTemplateManager.getProjectTemplate(templateKey);
        if (!result.isPresent()) {
            throw new TemplateInstantiationFailure(this.i18nResolver.getText("admin.addproject.projectemplate.template.not.found"), "");
        }
        ProjectTemplate projectTemplate = (ProjectTemplate)result.get();
        AddProjectHook addProjectHook = projectTemplate.getAddProjectHook();
        ProjectService.CreateProjectValidationResult projectTemplateValidationResult = this.validateProjectTemplateInstantiation(applyTemplateParam, addProjectHook);
        try {
            this.addUserToLicense(applyTemplateParam, projectTemplate.getProjectTypeKey());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Project project = this.projectService.createProject(projectTemplateValidationResult);
        return this.resultFactory.create(project);
    }

    @Override
    public Optional<ProjectTemplateKey> getAppliedProjectTemplateKey(Long projectId) {
        Optional<AppliedTemplate> appliedTemplate = Optional.ofNullable(this.appliedTemplateStorage.getByProjectId(projectId));
        return appliedTemplate.map(template -> {
            if (template.getProjectTemplateWebItemKey() != null) {
                return new ProjectTemplateKey(template.getProjectTemplateWebItemKey());
            }
            if (template.getProjectTemplateModuleKey() != null) {
                return new ProjectTemplateKey(template.getProjectTemplateModuleKey());
            }
            return null;
        });
    }

    private void addUserToLicense(ApplyTemplateParam applyTemplateParam, ProjectTypeKey projectTypeKey) throws AddException, PermissionException {
        if (!applyTemplateParam.getAddUserToLicense()) {
            return;
        }
        this.projectLicenseService.addUserToLicense(projectTypeKey, applyTemplateParam.getCurrentUser());
    }

    private ProjectService.CreateProjectValidationResult validateProjectTemplateInstantiation(ApplyTemplateParam template, AddProjectHook addProjectHook) {
        if (!this.permissionManager.hasPermission(0, template.getCurrentUser())) {
            throw new ValidationFailureException(this.createSingleError(this.i18nResolver.getText("admin.projects.service.error.no.admin.permission")));
        }
        ApplicationUser lead = this.userManager.getUserByName(template.getLeadName());
        ProjectService.CreateProjectValidationResult createProjectValidationResult = this.projectService.validateCreateProject(template.getCurrentUser(), new ProjectCreationData.Builder().withName(template.getProjectName()).withKey(template.getProjectKey()).withDescription(template.getProjectDescription()).withLead(lead).withUrl(template.getUrl()).withAssigneeType(template.getAssigneeType()).withProjectTemplateKey(template.getProjectTemplateWebItemKey()).build());
        ErrorCollection projectValidationErrors = createProjectValidationResult.getErrorCollection();
        ValidateResponse response = addProjectHook.validate(this.createValidateData(template));
        ErrorCollection templateValidationErrorCollection = ApiAccessor.toErrorCollection(response);
        projectValidationErrors.addErrorCollection(templateValidationErrorCollection);
        if (projectValidationErrors.hasAnyErrors()) {
            throw new ValidationFailureException(projectValidationErrors);
        }
        return createProjectValidationResult;
    }

    private ErrorCollection createSingleError(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        return errorCollection;
    }

    private ValidateData createValidateData(ApplyTemplateParam param) {
        String leadName = param.getLeadName();
        ApplicationUser lead = this.userManager.getUserByKey(leadName);
        return new ValidateData(param.getProjectName(), param.getProjectKey(), lead);
    }
}

