/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.api.ProjectConfigurator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.descriptor.ConfigTemplateParser;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.projecttemplates.service.ProjectConfigurationService;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;

public class ProjectConfiguratorImpl
implements ProjectConfigurator {
    private final ConfigTemplateParser configTemplateParser;
    private final PluginAccessor pluginAccessor;
    private final ProjectConfigurationService projectConfigurationService;

    public ProjectConfiguratorImpl(ConfigTemplateParser configTemplateParser, PluginAccessor pluginAccessor, ProjectConfigurationService projectConfigurationService) {
        this.configTemplateParser = configTemplateParser;
        this.pluginAccessor = pluginAccessor;
        this.projectConfigurationService = projectConfigurationService;
    }

    public ConfigureData configure(Project project, String configFileLocation, String pluginKey) {
        Plugin plugin = this.pluginAccessor.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            throw new IllegalArgumentException("No enabled plugin with key " + pluginKey);
        }
        ConfigTemplate configTemplate = this.configTemplateParser.parse(configFileLocation, plugin);
        return this.projectConfigurationService.configure(project, configTemplate);
    }
}

