/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.google.common.base.Predicate;

public class NameResolverImpl
implements NameResolver {
    private static final int MAX_NAME_LENGTH = 250;
    private final I18nTranslator i18nTranslator;

    public NameResolverImpl(I18nTranslator i18nTranslator) {
        this.i18nTranslator = i18nTranslator;
    }

    @Override
    public String getUniqueName(String projectKey, String nameI18nKey, Predicate<String> isNameUnique) {
        String proposedName = projectKey + ": " + this.i18nTranslator.getSystemTranslation(nameI18nKey);
        if (proposedName.length() > 250) {
            proposedName = proposedName.substring(0, 250);
        }
        return this.getUniqueName(proposedName, isNameUnique);
    }

    private String getUniqueName(String proposedName, Predicate<String> isNameUnique) {
        String name = proposedName;
        int counter = 1;
        while (!isNameUnique.apply((Object)name)) {
            name = proposedName + " (" + counter + ")";
            ++counter;
        }
        return name;
    }
}

