/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.template.hook.ScreenSchemeTemplate;
import com.atlassian.jira.projecttemplates.service.CustomScreenSchemeService;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Optional;

public class CustomScreenSchemeServiceImpl
implements CustomScreenSchemeService {
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final I18nTranslator i18nTranslator;
    private final NameResolver nameResolver;

    public CustomScreenSchemeServiceImpl(FieldScreenFactory fieldScreenFactory, FieldScreenSchemeManager fieldScreenSchemeManager, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.i18nTranslator = i18nTranslator;
        this.nameResolver = nameResolver;
    }

    @Override
    public FieldScreenScheme create(String projectKey, ScreenSchemeTemplate template, Map<String, FieldScreen> screens) {
        FieldScreenScheme screenScheme = this.fieldScreenFactory.createFieldScreenScheme();
        String name = this.nameResolver.getUniqueName(projectKey, template.name(), new IsScreenSchemeNameUnique());
        String description = this.i18nTranslator.getSystemTranslation(template.description());
        screenScheme.setName(name);
        screenScheme.setDescription(description);
        screenScheme.store();
        this.addSchemeEntity(screenScheme, template.defaultScreen(), null, screens);
        this.addSchemeEntity(screenScheme, template.createScreen(), IssueOperations.CREATE_ISSUE_OPERATION, screens);
        this.addSchemeEntity(screenScheme, template.editScreen(), IssueOperations.EDIT_ISSUE_OPERATION, screens);
        this.addSchemeEntity(screenScheme, template.viewScreen(), IssueOperations.VIEW_ISSUE_OPERATION, screens);
        return screenScheme;
    }

    private void addSchemeEntity(FieldScreenScheme screenScheme, Optional<String> screenKey, ScreenableIssueOperation operation, Map<String, FieldScreen> screens) {
        if (screenKey.isPresent()) {
            this.addSchemeEntity(screenScheme, screenKey.get(), operation, screens);
        }
    }

    private void addSchemeEntity(FieldScreenScheme screenScheme, String screenKey, ScreenableIssueOperation operation, Map<String, FieldScreen> screens) {
        FieldScreen screen = screens.get(screenKey);
        FieldScreenSchemeItem screenSchemeItem = this.fieldScreenFactory.createFieldScreenSchemeItem();
        screenSchemeItem.setFieldScreen(screen);
        screenSchemeItem.setIssueOperation(operation);
        screenScheme.addFieldScreenSchemeItem(screenSchemeItem);
    }

    private class IsScreenSchemeNameUnique
    implements Predicate<String> {
        private IsScreenSchemeNameUnique() {
        }

        public boolean apply(String name) {
            for (FieldScreenScheme screenScheme : CustomScreenSchemeServiceImpl.this.fieldScreenSchemeManager.getFieldScreenSchemes()) {
                if (!name.equals(screenScheme.getName())) continue;
                return false;
            }
            return true;
        }
    }
}

