/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.projecttemplates.model.IssueTypeSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomAvatarService;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeSchemeService;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomIssueTypeSchemeServiceImpl
implements CustomIssueTypeSchemeService {
    private static final String FAKE_AVATAR_ID = "-1";
    public static final String ISSUE_TYPE_NAME = "IssueType";
    private final ConstantsManager constantsManager;
    private final CustomAvatarService customAvatarService;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final I18nTranslator i18nTranslator;
    protected final ProjectManager projectManager;
    private final FieldManager fieldManager;
    private final NameResolver nameResolver;

    public CustomIssueTypeSchemeServiceImpl(ConstantsManager constantsManager, CustomAvatarService customAvatarService, FieldConfigSchemeManager fieldConfigSchemeManager, FieldManager fieldManager, ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this.constantsManager = constantsManager;
        this.customAvatarService = customAvatarService;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.projectManager = projectManager;
        this.fieldManager = fieldManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.i18nTranslator = i18nTranslator;
        this.nameResolver = nameResolver;
    }

    @Override
    public IssueTypeSchemeCreationResult configureCustomIssueTypeSchemeForProjectFromTemplate(Project project, ConfigTemplate configTemplate) {
        if (!configTemplate.issueTypeSchemeTemplate().isPresent()) {
            return new IssueTypeSchemeCreationResult();
        }
        IssueTypeSchemeTemplate issueTypeSchemeTemplate = (IssueTypeSchemeTemplate)configTemplate.issueTypeSchemeTemplate().get();
        Map<String, IssueType> issueTypeMap = this.getIssueTypesInstancesOfIssueTypeTemplateScheme(issueTypeSchemeTemplate);
        FieldConfigScheme issueTypeScheme = this.createIssueTypeScheme(issueTypeSchemeTemplate, issueTypeMap, project);
        return new IssueTypeSchemeCreationResult(issueTypeScheme, issueTypeMap);
    }

    private FieldConfigScheme createIssueTypeScheme(IssueTypeSchemeTemplate issueTypeSchemeTemplate, Map<String, IssueType> issueTypeMap, Project project) {
        String schemeName = this.nameResolver.getUniqueName(project.getKey(), issueTypeSchemeTemplate.name(), new IsIssueTypeSchemeNameUnique());
        Long[] projectIds = new Long[]{project.getId()};
        FieldConfigScheme issueTypeScheme = this.issueTypeSchemeManager.create(schemeName, this.i18nTranslator.getSystemTranslation(issueTypeSchemeTemplate.description()), this.getIssueTypeIds(issueTypeMap));
        List issueContexts = CustomFieldUtils.buildJiraIssueContexts((boolean)false, (Long[])projectIds, (ProjectManager)this.projectManager);
        issueTypeScheme = this.fieldConfigSchemeManager.updateFieldConfigScheme(issueTypeScheme, issueContexts, this.getIssueTypeField());
        this.setDefaultIssueType(issueTypeSchemeTemplate, issueTypeMap, issueTypeScheme);
        return issueTypeScheme;
    }

    private void setDefaultIssueType(IssueTypeSchemeTemplate issueTypeSchemeTemplate, Map<String, IssueType> issueTypeMap, FieldConfigScheme issueTypeScheme) {
        IssueType defaultIssueType;
        if (issueTypeSchemeTemplate.defaultIssueType().isPresent() && (defaultIssueType = issueTypeMap.get(issueTypeSchemeTemplate.defaultIssueType().get())) != null) {
            FieldConfig fieldConfig = issueTypeScheme.getOneAndOnlyConfig();
            this.issueTypeSchemeManager.setDefaultValue(fieldConfig, defaultIssueType.getId());
        }
    }

    private ConfigurableField getIssueTypeField() {
        return this.fieldManager.getConfigurableField("issuetype");
    }

    private List<String> getIssueTypeIds(Map<String, IssueType> issueTypes) {
        ArrayList issueTypeIds = Lists.newArrayList();
        for (IssueType issueType : issueTypes.values()) {
            issueTypeIds.add(issueType.getId());
        }
        return issueTypeIds;
    }

    private Map<String, IssueType> getIssueTypesInstancesOfIssueTypeTemplateScheme(IssueTypeSchemeTemplate schemeTemplate) {
        HashMap issueTypes = Maps.newHashMap();
        for (IssueTypeTemplate template : schemeTemplate.issueTypeTemplates()) {
            issueTypes.put(template.key(), this.getIssueType(template));
        }
        return issueTypes;
    }

    private IssueType getIssueType(IssueTypeTemplate issueTypeTemplate) {
        String name = this.i18nTranslator.getSystemTranslation(issueTypeTemplate.name());
        IssueType issueType = (IssueType)this.constantsManager.getConstantByNameIgnoreCase(ISSUE_TYPE_NAME, name);
        if (issueType == null) {
            issueType = this.createIssueTypeFromTemplate(issueTypeTemplate, name);
        }
        return issueType;
    }

    private IssueType createIssueTypeFromTemplate(IssueTypeTemplate issueTypeTemplate, String name) {
        IssueType issueType;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        String description = this.i18nTranslator.getSystemTranslation(issueTypeTemplate.description());
        this.constantsManager.validateCreateIssueTypeWithAvatar(name, issueTypeTemplate.style(), description, FAKE_AVATAR_ID, (ErrorCollection)errorCollection, ISSUE_TYPE_NAME);
        if (errorCollection.hasAnyErrors()) {
            throw new IllegalArgumentException("Validation error for issue type " + name + ": " + errorCollection.getErrors());
        }
        try {
            issueType = this.constantsManager.insertIssueType(name, null, issueTypeTemplate.style(), description, (Long)null);
        }
        catch (CreateException ex) {
            throw new IllegalArgumentException("Exception while creating Issue Type " + name, ex);
        }
        Long avatarId = this.customAvatarService.getOrCreateAvatar(issueTypeTemplate, issueType);
        this.constantsManager.updateIssueType(issueType.getId(), issueType.getName(), issueType.getSequence(), issueTypeTemplate.style(), description, avatarId);
        return this.constantsManager.getIssueTypeObject(issueType.getId());
    }

    private class IsIssueTypeSchemeNameUnique
    implements Predicate<String> {
        private IsIssueTypeSchemeNameUnique() {
        }

        public boolean apply(String name) {
            for (FieldConfigScheme scheme : CustomIssueTypeSchemeServiceImpl.this.fieldConfigSchemeManager.getConfigSchemesForField(CustomIssueTypeSchemeServiceImpl.this.getIssueTypeField())) {
                if (!scheme.getName().equalsIgnoreCase(name)) continue;
                return false;
            }
            return true;
        }
    }
}

