/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mywork.providers.jira;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.providers.jira.JiraAction;
import com.atlassian.mywork.util.GlobalIdFactory;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

public class FieldHelper {
    private static final String APP_JIRA = FieldHelper.class.getPackage().getName();
    static final String ENTITY_ISSUE = "issue";
    private static final String ENTITY_FILTER = "filter";
    private static final String ENTITY_JQL = "jql";
    private final HostApplication internalHostApplication;
    private final WatcherManager watcherManager;

    public FieldHelper(HostApplication internalHostApplication, WatcherManager watcherManager) {
        this.internalHostApplication = internalHostApplication;
        this.watcherManager = watcherManager;
    }

    public NotificationBuilder createNotification(ApplicationUser recipient, Issue issue, ApplicationUser actor, JiraAction action) {
        ObjectNode metadata = JsonNodeFactory.instance.objectNode();
        metadata.put("key", issue.getKey());
        metadata.put("summary", issue.getSummary());
        metadata.put("user", actor.getDisplayName());
        metadata.put("username", actor.getName());
        metadata.put("watching", this.watcherManager.isWatching(recipient, issue));
        return new NotificationBuilder().user(recipient.getName()).applicationLinkId(this.internalHostApplication.getId().get()).globalId(this.createGlobalId(ENTITY_ISSUE, issue.getId())).itemIconUrl(this.issueIconUrl(issue)).itemTitle(issue.getKey() + ": " + issue.getSummary()).iconUrl(this.createGravatarUrl(actor)).application(APP_JIRA).entity(ENTITY_ISSUE).action(action.name).metadata(metadata).actionIconUrl(action.iconUrl).itemUrl(this.issueUrl(issue)).url(this.issueUrl(issue));
    }

    public NotificationBuilder createNotification(SearchRequest filter, ApplicationUser actor, JiraAction action) {
        ObjectNode metadata = JsonNodeFactory.instance.objectNode();
        metadata.put("user", actor.getDisplayName());
        metadata.put("username", actor.getName());
        return new NotificationBuilder().applicationLinkId(this.internalHostApplication.getId().get()).globalId(this.createGlobalId(ENTITY_FILTER, filter.getId())).title(actor.getDisplayName() + " shared a filter with you.").itemIconUrl("/images/icons/ico_filters.png").itemTitle(filter.getName()).iconUrl(this.createGravatarUrl(actor)).application(APP_JIRA).entity(ENTITY_FILTER).action(action.name).metadata(metadata).actionIconUrl(action.iconUrl).itemUrl(this.filterUrl(filter)).url(this.filterUrl(filter));
    }

    public NotificationBuilder createNotification(String jql, ApplicationUser actor, JiraAction action) {
        ObjectNode metadata = JsonNodeFactory.instance.objectNode();
        metadata.put("user", actor.getDisplayName());
        metadata.put("username", actor.getName());
        return new NotificationBuilder().applicationLinkId(this.internalHostApplication.getId().get()).globalId(this.createGlobalId(ENTITY_JQL, DigestUtils.shaHex((byte[])jql.getBytes(Charsets.UTF_8)))).title(actor.getDisplayName() + " shared a search result with you.").itemIconUrl("/images/icons/ico_filters.png").itemTitle("Search Result").iconUrl(this.createGravatarUrl(actor)).application(APP_JIRA).entity(ENTITY_JQL).action(action.name).metadata(metadata).actionIconUrl(action.iconUrl).itemUrl(this.jqlUrl(jql)).url(this.jqlUrl(jql));
    }

    public String issueUrl(Issue issue) {
        return "/browse/" + issue.getKey();
    }

    public String issueCommentUrl(Issue issue, Comment comment) {
        return this.issueUrl(issue) + String.format("?focusedCommentId=%s#comment-%1$s", comment.getId());
    }

    public String issueIconUrl(Issue issue) {
        return issue.getIssueTypeObject().getIconUrl();
    }

    public String createGravatarUrl(ApplicationUser user) {
        return "/secure/useravatar?ownerId=" + FieldHelper.urlEncode(user.getName());
    }

    private String filterUrl(SearchRequest filter) {
        return "/secure/IssueNavigator.jspa?mode=hide&requestId=" + filter.getId();
    }

    private String jqlUrl(String jql) {
        return "/secure/IssueNavigator.jspa?reset=true&jqlQuery=" + FieldHelper.urlEncode(jql);
    }

    String createGlobalId(String entity, Object id) {
        return GlobalIdFactory.encode((List)ImmutableList.of((Object)"appId", (Object)"entity", (Object)"id"), (Map)ImmutableMap.of((Object)"appId", (Object)this.internalHostApplication.getId().get(), (Object)"entity", (Object)entity, (Object)"id", (Object)FieldHelper.urlEncode(id.toString())));
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

