/*
 * A simple widget that allows you to adjust the width of an element by dragging. The width is persisted in local
 * storage and restored on page reload.
 * jQuery UI plugin written by Atlassian and covered by AUI's license. http://developer.atlassian.com/display/AUI
 *
 * Depends:
 *   jquery.ui.widget.js (Specifically, needs Draggable. http://jqueryui.com/draggable/)
 *   Underscore.js
 */
(function(A){A.widget("ui.sidebar",{version:"0.1",options:{minWidth:function(B){return 50},maxWidth:function(B){return jQuery(window).width()},resize:A.noop},_create:function(){_.bindAll(this,"_handleDrag","_persist","_setContainment","updatePosition");if(!this.options.id){console.error("ui.sidebar: You must specify an id")}this._restore();this._addHandle();this.handle.mousedown(this._setContainment);this.handle.draggable({axis:"x",drag:this._handleDrag,stop:this._persist});this._handleResize=_.debounce(this.updatePosition,30);A(window).resize(this._handleResize)},_getLocalStorageKey:function(){return this.options.localStorageKey||"ui.sidebar."+this.options.id},_restore:function(){if(window.localStorage){var B=localStorage.getItem(this._getLocalStorageKey());if(B){this._setWidth(B)}}},_persist:function(){if(window.localStorage){localStorage.setItem(this._getLocalStorageKey(),this.element.outerWidth())}},_setContainment:function(){var B=jQuery(window).height();this._elementLeft=this.element.offset().left;this._minLeft=this._elementLeft+this.options.minWidth(this);this._maxLeft=Math.max(this._minLeft,this._elementLeft+this.options.maxWidth(this));this.handle.draggable({containment:[this._minLeft,B,this._maxLeft,B]})},_handleDrag:function(D,B){var C=B.position.left-this._elementLeft;this._setWidth(C,true)},_setWidth:function(E,D){if(!D){var C=this.options.maxWidth(this);var B=this.options.minWidth(this);if(E>C){E=C}else{if(E<B){E=B}}}this.element.width(E);this.options.resize(this,E);this._trigger("resize",null,E)},_addHandle:function(){this.handle=jQuery("<div />").addClass("ui-sidebar").appendTo(this.element);this._setHandlePosition()},_setHandlePosition:function(){this._setContainment();if(this._minLeft===this._maxLeft){this.handle.hide()}else{var C=this.element.offset();var B=C.left+this.element.outerWidth();this.handle.css({top:C.top,left:B,height:this.element.outerHeight()}).show()}},_destroy:function(){jQuery(window).unbind("resize",this._handleResize)},updatePosition:function(){this._setHandlePosition();this._setWidth(this.handle.offset().left-this._elementLeft);this._persist()}})})(jQuery);