define('feature/issues/issue-view',
    [
        'zepto',
        'layout/base/page-view',
        'layout/header/header-view',
        'feature/issues/comments/comments-view',
        'feature/issues/comments/add-comment-view',
        'feature/issues/fields/description',
        'feature/issues/fields/main-fields',
        'feature/issues/fields/all-fields',
        'feature/issues/header-view',
        'feature/issues/actions-view',
        'util/router',
        'util/events',
        'util/app-data'
    ],
    function (
        $,
        PageView,
        HeaderView,
        CommentView,
        AddCommentView,
        DescriptionView,
        MainFieldsView,
        AllFieldsView,
        IssueHeaderView,
        IssueActionView,
        router,
        events,
        appData) {

        return PageView.extend({
            className: 'card issue aui-page-panel user-content',

            desktopUrl: function () {
                return '/browse/' + this.model.get('key');
            },

            pageTitle: function () {
                return '[#' + this.model.get('key') + '] ' + this.model.get('fields').summary;
            },

            events: {
                'click .details-button': 'detailsModeSwitch',
                'click .action-menu-button': 'toggleActionMenu',
                'click .card.issue.aui-page-panel': 'actionMenuBlur',
                'click .comment-body img': 'openImage',
                'click .description-body img': 'openImage'
            },

            _updateData: function () {
                this.addComments = null;

                // The comments view
                var comments = this.model.get('renderedFields').comment;
                var canAddComment = this.model.get('permissions').canAddComment;
                // Only show the comment box if there are comments or an add comment box
                if (comments.total > 0 || canAddComment) {
                    if (!this.comments) {
                        this.comments = new CommentView({
                            model: this.model,
                            commentId: this.commentId
                        });
                    }
                } else if (this.comments) {
                    this.comments.close();
                    this.comments = null;
                }
                // Permission check
                if (canAddComment && !this.addComments) {
                    this.addComments = new AddCommentView({
                        issueKey: this.model.get('key'),
                        model: this.model
                    });
                } else if (this.addComments) {
                    this.addComments.close();
                    this.addComments = null;
                }
            },

            initialize: function (options) {
                this.issueHeader = new IssueHeaderView({
                    model: this.model
                });
                
                // Initialise the header
                var headerAttributes = {
                    el: this.$el,
                    title: this.model.key,
                    actionsView: this.issueHeader
                };
                if (this.options.showBackButton) {
                    // @i18n
                    _.extend(headerAttributes, {backText: AJS.I18n.getText('jira.mobile.back.button')});
                }
                this.header = new HeaderView(headerAttributes);
                // the actions menu
                this.issueActions = new IssueActionView({
                    parent: this,
                    model: this.model
                });

                // Initialise the main view
                this.mainFields = new MainFieldsView({
                    model: this.model
                });
                // The details view
                this.allFieldsView = new AllFieldsView({
                    model: this.model
                });
                this.descriptionView = new DescriptionView({
                    model: this.model
                });
                // Selected comment
                this.commentId = options.commentId;

                // Init comments
                this._updateData();
            },

            render: function () {
                this.$el.empty();
                this.header.render();
                this.issueActions.closeActionsIfOpen();
                this.$el.append(this.issueActions.render().$el);

                this.$el.append(this.mainFields.render().$el);
                this.$el.append(this.allFieldsView.render().$el);
                this.$el.append(this.descriptionView.render().$el);
                if (this.comments){
                    this.$el.append(this.comments.render().$el);
                }
                if (this.addComments) {
                    this.$el.append(this.addComments.render().$el);
                }
                this.$el.append(AtlassianMobile.Templates.JIRA.layout.atlasFooter());
            },

            toggleActionMenu: function () {
                this.issueActions.toggleShowActions();
            },

            actionMenuBlur: function (e) {
                var $target = $(e.target);
                // If the user clicked inside the action menu, then we don't want to close it
                if($target.closest('.issue-actions, .header').length === 0) {
                    this.issueActions.closeActionsIfOpen();
                }
            },

            openImage: function(e) {
                var $target = $(e.target);
                var src = $target.attr('src');
                if (src) {
                    document.location.href = src;
                }
            },

            detailsModeSwitch :function () {
                this.allFieldsView.setShow(!this.allFieldsView.show);
                if (this.allFieldsView.show) {
                    this.$el.find('.details-button').text(AJS.I18n.getText('jira.mobile.more.fields.button.alt'));
                } else {
                    this.$el.find('.details-button').text(AJS.I18n.getText('jira.mobile.more.fields.button'));
                }
                this.allFieldsView.render();
            }
        });
    }
);