/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter.mapper;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.mobile.servlet.filter.mapper.URLTracker;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class IssueNavURLTracker
implements URLTracker {
    private static final Pattern PATTERN = Pattern.compile("\\/issues\\/");
    private static final String PREFIX = "/issues";
    private SearchRequestStore searchRequestStore;
    private ShareManager shareManager;

    @Override
    public boolean matches(String path) {
        Matcher matcher = PATTERN.matcher(path);
        boolean correctPrefix = path.startsWith(PREFIX);
        boolean matchesPattern = matcher.matches();
        return correctPrefix && matchesPattern;
    }

    @Override
    public String map(String path, HttpServletRequest request) throws UnsupportedEncodingException {
        if (this.matches(path)) {
            String jql = request.getParameter("jql");
            String filterId = request.getParameter("filter");
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotBlank((String)jql)) {
                sb.append("filter/jql/").append(JiraUrlCodec.encode((String)jql, (String)"UTF-8", (boolean)true));
                if (StringUtils.isNotBlank((String)filterId)) {
                    sb.append("/").append(JiraUrlCodec.encode((String)filterId, (String)"UTF-8", (boolean)true));
                }
            } else if (StringUtils.isNotBlank((String)filterId)) {
                if (filterId.trim().equals("-1")) {
                    sb.append("filter/assigned");
                } else if (filterId.trim().equals("-2")) {
                    sb.append("filter/reported");
                } else if (filterId.trim().equals("-3")) {
                    sb.append("filter/recent");
                } else if (filterId.trim().equals("-4")) {
                    sb.append("filter/all");
                } else {
                    sb.append("filter/").append(JiraUrlCodec.encode((String)filterId, (String)"UTF-8", (boolean)true));
                }
            } else {
                sb.append("filter/all");
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public boolean requiresLogin(String path, HttpServletRequest request, ApplicationUser user) {
        String rawFilterId;
        if (this.matches(path) && user == null && StringUtils.isNotBlank((String)(rawFilterId = request.getParameter("filter")))) {
            if (rawFilterId.trim().equals("-4") || rawFilterId.trim().equals("-3")) {
                return false;
            }
            if (NumberUtils.isDigits((String)rawFilterId)) {
                SearchRequest searchRequest = this.getSearchRequestStore().getSearchRequest(NumberUtils.createLong((String)rawFilterId));
                if (this.getShareManager().isSharedWith(user, (SharedEntity)searchRequest)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private ShareManager getShareManager() {
        if (this.shareManager == null) {
            this.shareManager = (ShareManager)ComponentAccessor.getComponent(ShareManager.class);
            return this.shareManager;
        }
        return this.shareManager;
    }

    private SearchRequestStore getSearchRequestStore() {
        if (this.searchRequestStore == null) {
            this.searchRequestStore = (SearchRequestStore)ComponentAccessor.getComponent(SearchRequestStore.class);
            return this.searchRequestStore;
        }
        return this.searchRequestStore;
    }
}

