/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MobileRedirectFilter
implements Filter {
    private final MobileURLTrackerService mobileURLTrackerService;
    private String redirectPrefix;

    public MobileRedirectFilter(MobileURLTrackerService mobileURLTrackerService) {
        this.mobileURLTrackerService = mobileURLTrackerService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain next) throws IOException, ServletException {
        String fragment;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURI();
        String context = request.getContextPath();
        String path = url.substring(context.length());
        if (MobileUtils.isMobileViewRequest(request) && (fragment = this.mobileURLTrackerService.mapPath(path, request)) != null) {
            String redirectUrl = String.format("%s%s#%s", context, this.redirectPrefix, fragment);
            response.sendRedirect(redirectUrl);
            return;
        }
        next.doFilter(servletRequest, servletResponse);
    }
}

