/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter;

import com.atlassian.jira.mobile.servlet.filter.mapper.MobileURLTrackerService;
import com.atlassian.jira.mobile.utils.MobileUtils;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class MobileAuthenticationFilter
implements Filter {
    private final UserManager userManager;
    private final MobileURLTrackerService mobileURLTrackerService;
    private String redirectPrefix;
    private static final String LOGIN_URL = "/login.jsp";

    public MobileAuthenticationFilter(UserManager userManager, MobileURLTrackerService mobileURLTrackerService) {
        this.userManager = userManager;
        this.mobileURLTrackerService = mobileURLTrackerService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.redirectPrefix = filterConfig.getInitParameter("redirectPrefix");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String fragment;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        UserProfile remoteUser = this.userManager.getRemoteUser(request);
        String loggedInUsername = remoteUser != null ? remoteUser.getUsername() : null;
        String context = request.getContextPath();
        if (MobileUtils.isMobileViewRequest(request) && this.mobileURLTrackerService.requiresLogin(this.getDestinationPath(context, request), request, loggedInUsername) && StringUtils.isNotBlank((String)(fragment = this.getMobileDestination(context, request))) && !this.isLoginPage(context, request)) {
            response.sendRedirect(this.getBaseLoginPageRedirectPath(context, fragment));
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String getDestinationPath(String context, HttpServletRequest request) {
        String path = request.getParameter("os_destination");
        if (StringUtils.isBlank((String)path)) {
            String url = request.getRequestURI();
            path = url.substring(context.length());
        }
        return path;
    }

    private String getMobileDestination(String context, HttpServletRequest request) {
        String path = this.getDestinationPath(context, request);
        String fragment = this.mobileURLTrackerService.mapPath(path, request);
        return fragment;
    }

    private boolean isLoginPage(String context, HttpServletRequest request) {
        String path = this.getDestinationPath(context, request);
        return path.startsWith(LOGIN_URL);
    }

    private String getBaseLoginPageRedirectPath(String context, String fragment) throws UnsupportedEncodingException {
        String redirectUrl = String.format("%s#%s", this.redirectPrefix, fragment);
        String osDestination = URLEncoder.encode(redirectUrl, "UTF-8");
        return context + LOGIN_URL + "?os_destination=" + osDestination;
    }
}

