/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.mobile.compat.SingleSignOnSolutionAccessor;
import com.atlassian.jira.mobile.resource.filter.CSSFilter;
import com.atlassian.jira.mobile.resource.filter.JSFilter;
import com.atlassian.jira.mobile.resource.manager.MobileResourceServerServletUrlRewriter;
import com.atlassian.jira.mobile.resource.manager.MobileWebResourceManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MobileServlet
extends HttpServlet {
    private SoyTemplateRenderer soyTemplateRenderer;
    private final SingleSignOnSolutionAccessor singleSignOnSolutionAccessor;
    private final MobileWebResourceManager webResourceManager;
    private final com.atlassian.sal.api.user.UserManager userManager;
    private final UserManager jiraUserManager;
    private final ApplicationProperties applicationProperties;
    private final JiraBaseUrls jiraBaseUrls;

    public MobileServlet(com.atlassian.sal.api.user.UserManager userManager, ApplicationProperties applicationProperties, MobileWebResourceManager mobileWebResourceManager, UserManager jiraUserManager, JiraBaseUrls jiraBaseUrls, SingleSignOnSolutionAccessor singleSignOnSolutionAccessor) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.webResourceManager = mobileWebResourceManager;
        this.singleSignOnSolutionAccessor = singleSignOnSolutionAccessor;
        this.jiraUserManager = jiraUserManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode"));
        Map<String, Object> context = this.getHomeContext();
        context.put("username", this.userManager.getRemoteUsername(request));
        context.put("user", this.getUser(request));
        context.put("contextPath", request.getContextPath());
        context.put("appTitle", this.applicationProperties.getString("jira.title"));
        context.put("hasSSO", this.singleSignOnSolutionAccessor.hasSSO());
        context.put("isAnalyticsEnabled", isDevMode == false && this.webResourceManager.isAnalyticsInstalled() != false);
        String templateName = "homePage";
        String pageParam = request.getParameter("page");
        if ("login".equals(pageParam)) {
            templateName = "login";
            context.put("loginPath", request.getContextPath() + "/rest/mobile/1.0/login");
            context.put("destination", request.getParameter("os_destination"));
        }
        String result = this.renderSoyTemplate("com.atlassian.jira.mobile:mobile-layout", "AtlassianMobile.Templates.JIRA.layout." + templateName, context);
        response.getWriter().append(result);
    }

    private Map<String, Object> getHomeContext() {
        HashMap context = Maps.newHashMap();
        HashMap resources = Maps.newHashMap();
        this.webResourceManager.assembler().assembled().drainIncludedResources();
        this.webResourceManager.assembler().resources().requireContext("mob-general");
        WebResourceSet set = this.webResourceManager.assembler().assembled().drainIncludedResources();
        StringWriter headerResources = new StringWriter();
        set.writeHtmlTags((Writer)headerResources, UrlMode.RELATIVE, CSSFilter.PREDICATE);
        StringWriter footerResources = new StringWriter();
        footerResources.append(this.webResourceManager.getSoyDependenciesTags());
        set.writeHtmlTags((Writer)footerResources, UrlMode.RELATIVE, JSFilter.PREDICATE);
        footerResources.append(this.webResourceManager.getAnalyticsTags());
        resources.put("header", this.reMap(headerResources.toString()));
        resources.put("footer", this.reMap(footerResources.toString()));
        context.put("resources", resources);
        return context;
    }

    private UserJsonBean getUser(HttpServletRequest request) {
        String userName = this.userManager.getRemoteUsername(request);
        ApplicationUser user = this.jiraUserManager.getUserByName(userName);
        return UserJsonBean.shortBean((ApplicationUser)user, (JiraBaseUrls)this.jiraBaseUrls);
    }

    private String renderSoyTemplate(String pluginKey, String template, Map<String, Object> context) {
        try {
            return this.getSoyTemplateRenderer().render(pluginKey, template, context);
        }
        catch (SoyException e) {
            return "";
        }
    }

    private SoyTemplateRenderer getSoyTemplateRenderer() {
        if (this.soyTemplateRenderer == null) {
            this.soyTemplateRenderer = (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
            return this.soyTemplateRenderer;
        }
        return this.soyTemplateRenderer;
    }

    private String reMap(String s) {
        return MobileResourceServerServletUrlRewriter.apply(s);
    }
}

