/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.rest.json.beans.IssueLinksBeanBuilderFactory;
import com.atlassian.jira.mobile.rest.fields.MobileIssueBeanBuilder;
import com.atlassian.jira.mobile.rest.util.BaseRestResource;
import com.atlassian.jira.mobile.rest.util.IssueFinder;
import com.atlassian.jira.mobile.rest.util.MobileBeanBuilderFactory;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.StringList;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/issue")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MobileIssueResource
extends BaseRestResource {
    private final IssueFinder issueFinder;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext authContext;
    private final FieldManager fieldManager;
    private final MobileBeanBuilderFactory builderFactoryFactory;
    private final IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory;
    private final IssueWorkflowManager issueWorkflowManager;
    private final UserIssueHistoryManager userIssueHistoryManager;

    public MobileIssueResource(IssueFinder issueFinder, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext authContext, FieldManager fieldManager, IssueLinksBeanBuilderFactory issueLinkBeanBuilderFactory, IssueWorkflowManager issueWorkflowManager, MobileBeanBuilderFactory builderFactoryFactory, UserIssueHistoryManager userIssueHistoryManager) {
        super(MobileIssueResource.class, authContext);
        this.issueFinder = issueFinder;
        this.fieldLayoutManager = fieldLayoutManager;
        this.authContext = authContext;
        this.fieldManager = fieldManager;
        this.issueLinkBeanBuilderFactory = issueLinkBeanBuilderFactory;
        this.issueWorkflowManager = issueWorkflowManager;
        this.builderFactoryFactory = builderFactoryFactory;
        this.userIssueHistoryManager = userIssueHistoryManager;
    }

    @GET
    @Path(value="{issueIdOrKey}")
    public Response getIssue(final @PathParam(value="issueIdOrKey") String issueIdOrKey, final @QueryParam(value="fields") List<StringList> fields, final @QueryParam(value="expand") String expand) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                MutableIssue issue = MobileIssueResource.this.issueFinder.findIssue(issueIdOrKey);
                if (issue == null) {
                    return MobileIssueResource.this.notFoundRequest("404.issue.not.present");
                }
                if (MobileIssueResource.this.issueFinder.checkIssuePermission((Issue)issue) == null) {
                    if (MobileIssueResource.this.getLoggedInUser() == null) {
                        return MobileIssueResource.this.unauthorizedRequest("401.login.required");
                    }
                    return MobileIssueResource.this.forbiddenRequest("403.no.permission");
                }
                IncludedFields include = IncludedFields.includeAllByDefault((List)fields);
                MobileIssueResource.this.userIssueHistoryManager.addIssueToHistory(MobileIssueResource.this.getLoggedInUser(), (Issue)issue);
                IssueBean bean = MobileIssueResource.this.getIssueBeanBuilder((Issue)issue, include).expand(expand).build();
                return Response.ok((Object)bean).cacheControl(CacheControl.never()).build();
            }
        });
    }

    private MobileIssueBeanBuilder getIssueBeanBuilder(Issue issue, IncludedFields fieldsToInclude) {
        return new MobileIssueBeanBuilder(this.fieldLayoutManager, this.authContext, this.fieldManager, this.builderFactoryFactory, issue, fieldsToInclude, this.issueLinkBeanBuilderFactory, this.issueWorkflowManager, this.getLoggedInUser());
    }
}

