/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mobile.rest.fields.AddCommentMetaBean;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;

public class AddCommentMetaBeanBuilder {
    private final ProjectRoleManager projectRoleManager;
    private final GroupManager groupManager;
    private final ApplicationProperties jiraApplicationProperties;

    public AddCommentMetaBeanBuilder(ProjectRoleManager projectRoleManager, GroupManager groupManager, ApplicationProperties jiraApplicationProperties) {
        this.projectRoleManager = projectRoleManager;
        this.groupManager = groupManager;
        this.jiraApplicationProperties = jiraApplicationProperties;
    }

    public AddCommentMetaBean build(ApplicationUser user, Issue issue) {
        if (user == null) {
            return new AddCommentMetaBean(null, null);
        }
        Collection roles = this.projectRoleManager.getProjectRoles(user, issue.getProjectObject());
        if (this.isGroupVisiblityEnabled()) {
            Collection groups = this.groupManager.getGroupsForUser(user);
            return new AddCommentMetaBean(groups, roles);
        }
        return new AddCommentMetaBean(null, roles);
    }

    private boolean isGroupVisiblityEnabled() {
        return this.jiraApplicationProperties.getOption("jira.comment.level.visibility.groups");
    }
}

