/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.compat.lasso;

import com.atlassian.jira.mobile.compat.lasso.LassoPluginFactory;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class LassoPluginAccessor {
    private static final Logger log = LoggerFactory.getLogger(LassoPluginAccessor.class);
    @Resource
    private ApplicationContext applicationContext;
    private Object lassoPlugin;
    private boolean failed = false;

    public synchronized boolean isLassoEnabled() {
        try {
            Object lasso = this.getLasso();
            Class<?> lassoClass = lasso.getClass();
            Method isEnabled = lassoClass.getMethod("isPluginEnabled", new Class[0]);
            Object returnValue = isEnabled.invoke(lasso, new Object[0]);
            return (Boolean)returnValue;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Object getLasso() {
        if (this.failed) {
            return null;
        }
        if (this.lassoPlugin == null) {
            this.initLasso();
        }
        return this.lassoPlugin;
    }

    private void initLasso() {
        try {
            this.lassoPlugin = ((LassoPluginFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(LassoPluginFactory.class, 3, false)).get();
        }
        catch (Exception e) {
            this.failed = true;
            log.debug("Could not find LassoPlugin", (Throwable)e);
        }
    }
}

