/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aui.javascript;

import com.atlassian.aui.javascript.JavaScriptUtil;
import com.atlassian.aui.javascript.SearchAndReplaceDownloadableResource;
import com.atlassian.aui.javascript.SearchAndReplacer;
import com.atlassian.aui.spi.AuiIntegration;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class JsI18nTransformer
implements WebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("AJS\\.I18n\\.getText\\(\\s*(['\"])([\\w.-]+)\\1\\s*([\\),])");
    private final AuiIntegration auiIntegration;
    private final SearchAndReplacer grep;

    public JsI18nTransformer(AuiIntegration auiIntegration) {
        this.auiIntegration = auiIntegration;
        Function<Matcher, String> replacer = new Function<Matcher, String>(){

            public String apply(Matcher matcher) {
                return JsI18nTransformer.this.doReplace(matcher);
            }
        };
        this.grep = new SearchAndReplacer(PATTERN, replacer);
    }

    private String doReplace(Matcher matcher) {
        String key = matcher.group(2);
        boolean format = ",".equals(matcher.group(3));
        StringBuilder result = new StringBuilder();
        if (format) {
            result.append("AJS.format(");
            result.append("\"").append(JavaScriptUtil.escape(this.auiIntegration.getRawText(key))).append("\"");
            result.append(",");
        } else {
            result.append("\"").append(JavaScriptUtil.escape(this.auiIntegration.getText(key, new Serializable[0]))).append("\"");
        }
        return result.toString();
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new SearchAndReplaceDownloadableResource(nextResource, this.grep);
    }
}

