AJS.test.require([
    "com.atlassian.plugin.jslibs:brace-2014.09.03-factory",
    "com.atlassian.plugin.jslibs:backbone-1.0.0-factory",
    "com.atlassian.plugin.jslibs:underscore-1.5.2"
], function () {
    "use strict";

    require([
        "atlassian/libs/factories/brace-2014.09.03",
        "atlassian/libs/factories/backbone-1.0.0",
        "atlassian/libs/underscore-1.5.2",
        "jquery"
    ], function (
        BraceFactory,
        BackboneFactory,
        _,
        $
    ) {
        var Backbone = BackboneFactory(_, $);

        module("atlassian/libs/factories/brace-2014.09.03", {
            setup: function() {
                this.sandbox = sinon.sandbox.create();
            },
            teardown: function() {
                this.sandbox.restore();
            }
        });

        test("It returns a function", function () {
            ok(typeof BraceFactory == "function");
        });

        test("It returns a copy of Brace 2014.09.03", function () {
            var Brace = BraceFactory(_, Backbone);

            ok(Brace.VERSION == "2014.09.03");
        });

        test("Each call returns a new copy", function () {
            var Brace1 = BraceFactory(_, Backbone);
            var Brace2 = BraceFactory(_, Backbone);

            ok(Brace1 !== Brace2);
        });

        test("It uses the provided Backbone", function () {
            this.spy(Backbone.Model, "extend");
            BraceFactory(_, Backbone);

            sinon.assert.called(Backbone.Model.extend);
        });

        test("It uses the provided Underscore", function () {
            this.spy(_, "extend");
            BraceFactory(_, Backbone);

            sinon.assert.called(_.extend);
        });
    });
});
