/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.util;

import com.atlassian.jira.plugins.workflow.sharing.util.HttpResult;
import com.atlassian.jira.plugins.workflow.sharing.util.HttpUtils;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.impl.HttpHelper;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class CommonsHttpClientHelper
implements HttpHelper {
    public HttpHelper.Response get(URI uri) throws MpacException {
        HttpGet method = new HttpGet(uri);
        return this.executeMethod((HttpRequestBase)method);
    }

    public HttpHelper.Response postParams(URI uri, Multimap<String, String> params) throws MpacException {
        HttpPost method = new HttpPost(uri);
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry param : params.entries()) {
            formParams.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
        try {
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
        }
        catch (UnsupportedEncodingException e) {
            throw new MpacException((Throwable)e);
        }
        return this.executeMethod((HttpRequestBase)method);
    }

    public HttpHelper.Response put(URI uri, byte[] content) throws MpacException {
        HttpPut method = new HttpPut(uri);
        method.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.APPLICATION_JSON));
        return this.executeMethod((HttpRequestBase)method);
    }

    public HttpHelper.Response delete(URI uri) throws MpacException {
        HttpDelete method = new HttpDelete(uri);
        return this.executeMethod((HttpRequestBase)method);
    }

    private ResponseImpl executeMethod(HttpRequestBase method) throws MpacException {
        try {
            return new ResponseImpl(method);
        }
        catch (SocketException e) {
            throw new MpacException.ConnectionFailure(e);
        }
        catch (IOException e) {
            throw new MpacException((Throwable)e);
        }
    }

    private static class ResponseImpl
    implements HttpHelper.Response {
        private HttpResult result;
        private HttpResponse response;

        public ResponseImpl(HttpRequestBase method) throws IOException {
            try {
                this.result = HttpUtils.execute(method);
                this.response = this.result.getResponse();
            }
            catch (IOException e) {
                if (this.result != null) {
                    this.result.close();
                }
                throw e;
            }
        }

        public int getStatus() {
            return this.response.getStatusLine().getStatusCode();
        }

        public InputStream getContentStream() throws MpacException {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException e) {
                throw new MpacException((Throwable)e);
            }
        }

        public boolean isEmpty() {
            Header h = this.response.getFirstHeader("Content-Length");
            return h != null && h.getValue().trim().equals("0");
        }

        public void close() {
            if (this.response.getEntity() != null) {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
            this.result.close();
        }
    }
}

