/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.servlet;

public enum ServletMapping {
    START_EXPORT("wfshare-export", "exporter/start-export.vm"),
    EXPORT_ADD_NOTES("add-notes", "exporter/export-add-notes.vm"),
    EXPORT_WORKFLOW("export-workflow", ""),
    EXPORT_WORKFLOW_SUCCESS("export-workflow-success", "exporter/export-success.vm"),
    IMPORT_CHOOSE_ZIP("wfshare-import", "importer/import-choose-zip.vm"),
    IMPORT_SET_NAME("set-workflow-name", "importer/import-choose-name.vm"),
    IMPORT_MAP_STATUSES("map-statuses", "importer/import-map-statuses.vm"),
    IMPORT_VIEW_SUMMARY("summary", "importer/import-summary.vm"),
    IMPORT_WORKFLOW("import-workflow", ""),
    IMPORT_WORKFLOW_SUCCESS("import-workflow-success", "importer/import-success.vm"),
    EXPORT_ERROR("", "export-error.vm"),
    IMPORT_ERROR("", "import-error.vm"),
    NOT_MAPPED("", "");

    public static final String TEMPLATE_PREFIX = "/templates/workflow-sharing/";
    private String path;
    private String resultTemplate;

    private ServletMapping(String path, String template) {
        this.path = path;
        this.resultTemplate = TEMPLATE_PREFIX + template;
    }

    public String getPath() {
        return this.path;
    }

    public String getResultTemplate() {
        return this.resultTemplate;
    }

    public ServletMapping previous() {
        if (this.ordinal() > 0) {
            return ServletMapping.values()[this.ordinal() - 1];
        }
        return null;
    }

    public static ServletMapping fromPath(String path) {
        for (ServletMapping mapping : ServletMapping.values()) {
            if (!mapping.getPath().equals(path)) continue;
            return mapping;
        }
        return NOT_MAPPED;
    }
}

