/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.servlet;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.gzipfilter.org.apache.commons.lang.WordUtils;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.status.SimpleStatus;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.plugins.workflow.sharing.event.ImportWorkflowViewedEvent;
import com.atlassian.jira.plugins.workflow.sharing.importer.JiraWorkflowSharingImporter;
import com.atlassian.jira.plugins.workflow.sharing.importer.SharedWorkflowImportPlan;
import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.PacBundleDownloader;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.ScreenCreator;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowImporterFactory;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowStatusHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.WorkflowExtensionsPluginInfo;
import com.atlassian.jira.plugins.workflow.sharing.servlet.AbstractServletWizardHandler;
import com.atlassian.jira.plugins.workflow.sharing.servlet.DataNotFoundInSessionException;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ServletMapping;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportWizardHandler
extends AbstractServletWizardHandler {
    private final Logger LOG = LoggerFactory.getLogger(ImportWizardHandler.class);
    public static final String WF_NAME_FIELD_NAME = "wfShareWorkflowName";
    public static final String BUNDLE_DOWNLOAD_URL_FIELD_NAME = "wfShareBundleDownloadUrl";
    public static final String BUNDLE_FILENAME_FIELD_NAME = "wfShareBundleFilename";
    public static final String PARAM_STATUS_FOR_PREFIX = "status-for-";
    public static final String PROJECT_ID_PARAM = "projectId";
    public static final String SCHEME_ID_PARAM = "schemeId";
    public static final String SRC_PARAM = "src";
    private final TemplateRenderer renderer;
    private final WorkflowImporterFactory importerFactory;
    private final WorkflowManager workflowManager;
    private final WorkflowStatusHelper workflowStatusHelper;
    private final VelocityRequestContextFactory requestContextFactory;
    private final PacBundleDownloader pacFileDownloader;
    private final ScreenCreator screenCreator;
    private final WorkflowBundle.Factory factory;
    private final WebSudoManager webSudoManager;
    private final ProjectManager projectManager;
    private final PluginAccessor pluginAccessor;
    private final EventPublisher eventPublisher;
    private final StatusService statusService;

    public ImportWizardHandler(LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, UserManager userManager, TemplateRenderer renderer, WorkflowImporterFactory importerFactory, WorkflowManager workflowManager, I18nResolver i18n, WorkflowStatusHelper workflowStatusHelper, VelocityRequestContextFactory requestContextFactory, PacBundleDownloader pacFileDownloader, ScreenCreator screenCreator, WorkflowBundle.Factory factory, XsrfTokenValidator xsrfTokenValidator, XsrfTokenGenerator xsrfTokenGenerator, ApplicationProperties applicationProperties, ProjectManager projectManager, PluginAccessor pluginAccessor, EventPublisher eventPublisher, StatusService statusService) {
        super(loginUriProvider, userManager, i18n, xsrfTokenValidator, xsrfTokenGenerator, applicationProperties);
        this.webSudoManager = webSudoManager;
        this.renderer = renderer;
        this.importerFactory = importerFactory;
        this.workflowManager = workflowManager;
        this.workflowStatusHelper = workflowStatusHelper;
        this.requestContextFactory = requestContextFactory;
        this.pacFileDownloader = pacFileDownloader;
        this.screenCreator = screenCreator;
        this.factory = factory;
        this.projectManager = projectManager;
        this.pluginAccessor = pluginAccessor;
        this.eventPublisher = eventPublisher;
        this.statusService = statusService;
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response, AbstractServletWizardHandler.RequestHandler handler) throws IOException {
        if (this.enforceAdminLogin(request, response)) {
            return;
        }
        JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
        response.setContentType("text/html;charset=utf-8");
        super.clearSessionAttributes(request.getSession());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("requestContext", this.requestContextFactory.getJiraVelocityRequestContext());
        context.put("soyRenderer", this.getSoyRenderer());
        ServletMapping requestMapping = ServletMapping.fromPath(this.getMappingPath(request));
        context.put("cancelUrl", this.getCancelUrl(request));
        try {
            handler.handle(request, response, context, requestMapping);
        }
        catch (DataNotFoundInSessionException e) {
            response.sendRedirect(ServletMapping.IMPORT_CHOOSE_ZIP.getPath() + "?" + "notFoundInSession" + "=true");
        }
        catch (Exception e) {
            this.LOG.debug("Unable to import workflow", (Throwable)e);
            String message = e.getMessage();
            if (StringUtils.isBlank((String)message)) {
                message = this.i18n.getText("wfshare.import.error.generic");
            }
            this.showError(message, request, response, context);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.recordSource(request.getParameter(SRC_PARAM));
        this.handleRequest(request, response, new AbstractServletWizardHandler.RequestHandler(){

            @Override
            public void handle(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context, ServletMapping requestMapping) throws DataNotFoundInSessionException, IOException, ServletException, ValidationException {
                switch (requestMapping) {
                    case IMPORT_CHOOSE_ZIP: {
                        ImportWizardHandler.this.showChooseZip(request, response, context, requestMapping);
                        break;
                    }
                    case IMPORT_SET_NAME: {
                        ImportWizardHandler.this.showChooseName(request, response, context);
                        break;
                    }
                    case IMPORT_MAP_STATUSES: {
                        ImportWizardHandler.this.showMapStatuses(request, response, context);
                        break;
                    }
                    case IMPORT_VIEW_SUMMARY: {
                        ImportWizardHandler.this.showSummary(request, response, context);
                        break;
                    }
                    case IMPORT_WORKFLOW: {
                        ImportWizardHandler.this.doImport(request, response);
                        break;
                    }
                    case IMPORT_WORKFLOW_SUCCESS: {
                        ImportWizardHandler.this.showSuccess(request, response, context);
                    }
                }
            }
        });
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.handleRequest(request, response, new AbstractServletWizardHandler.RequestHandler(){

            @Override
            public void handle(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context, ServletMapping requestMapping) throws DataNotFoundInSessionException, IOException, ValidationException, URISyntaxException, ServletException {
                switch (requestMapping) {
                    case IMPORT_CHOOSE_ZIP: {
                        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request) && null != request.getParameter(ImportWizardHandler.BUNDLE_DOWNLOAD_URL_FIELD_NAME)) {
                            ImportWizardHandler.this.doDownloadMarketplaceZip(request, response, context);
                            break;
                        }
                        if (request.getParameter(ImportWizardHandler.WF_NAME_FIELD_NAME) != null) break;
                        ImportWizardHandler.this.doUploadZip(request, response, context);
                        break;
                    }
                    case IMPORT_SET_NAME: {
                        ImportWizardHandler.this.doSetName(request, response, context);
                        break;
                    }
                    case IMPORT_MAP_STATUSES: {
                        ImportWizardHandler.this.doMapStatuses(request, response);
                        break;
                    }
                    case IMPORT_WORKFLOW: {
                        ImportWizardHandler.this.doImport(request, response);
                    }
                }
            }
        });
    }

    private void recordSource(String src) {
        this.eventPublisher.publish((Object)new ImportWorkflowViewedEvent(src));
    }

    private void showError(String error, HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException {
        String errorTemplate = ServletMapping.IMPORT_ERROR.getResultTemplate();
        context.put("errorMessage", error);
        SharedWorkflowImportPlan plan = this.getPlanOrNull(request);
        context.put("source", (Object)(plan == null ? null : plan.getSource()));
        this.clearSessionAttributes(request.getSession());
        this.renderer.render(errorTemplate, context, (Writer)response.getWriter());
    }

    private void showChooseZip(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context, ServletMapping servletMapping) throws IOException, ValidationException {
        Long projectId;
        this.addDataNotFoundInSessionParam(request, context);
        Long schemeId = this.getLongParameter(request, SCHEME_ID_PARAM);
        if (schemeId == null) {
            schemeId = this.getSessionVar(request, SessionVar.SCHEME_ID);
        }
        if ((projectId = this.getLongParameter(request, PROJECT_ID_PARAM)) == null) {
            projectId = this.getSessionVar(request, SessionVar.PROJECT_ID);
        }
        context.put("cancelUrl", this.getCancelUrl(projectId, schemeId, request));
        context.put(PROJECT_ID_PARAM, projectId == null ? "" : projectId);
        context.put(SCHEME_ID_PARAM, schemeId == null ? "" : schemeId);
        this.setNavigationPaths(context, servletMapping);
        context.put("isSysAdmin", this.isSystemAdmin());
        this.renderer.render(servletMapping.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private void addDataNotFoundInSessionParam(HttpServletRequest request, Map<String, Object> context) {
        String dataNotFoundInSession = request.getParameter("notFoundInSession");
        if (StringUtils.isNotEmpty((String)dataNotFoundInSession)) {
            context.put("errorMessage", this.i18n.getText("wfshare.exception.import.data.not.found.in.session"));
        }
    }

    private String getCancelUrl(HttpServletRequest request) {
        Long schemeId = this.getSessionVar(request, SessionVar.SCHEME_ID);
        Long projectId = this.getSessionVar(request, SessionVar.PROJECT_ID);
        return this.getCancelUrl(projectId, schemeId, request);
    }

    private String getCancelUrl(Long projectId, Long schemeId, HttpServletRequest request) {
        String cancelUrl = "/secure/admin/workflows/ListWorkflows.jspa";
        if (projectId != null) {
            Project project = this.projectManager.getProjectObj(projectId);
            if (project != null) {
                cancelUrl = "/plugins/servlet/project-config/" + project.getKey() + "/workflows";
            }
        } else if (schemeId != null) {
            cancelUrl = "/secure/admin/EditWorkflowScheme.jspa?schemeId=" + schemeId;
        }
        return request.getContextPath() + cancelUrl;
    }

    private void doDownloadMarketplaceZip(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException {
        try {
            this.clearSessionAttributes(request.getSession());
            String downloadUrl = request.getParameter(BUNDLE_DOWNLOAD_URL_FIELD_NAME);
            String filename = request.getParameter(BUNDLE_FILENAME_FIELD_NAME);
            request.getSession().setAttribute(SessionVar.WFSHARE_WORKFLOW_NAME.name(), (Object)this.createWorkflowNameFromFilename(filename));
            SharedWorkflowImportPlan plan = this.createPlan(this.pacFileDownloader.downloadBundle(downloadUrl));
            request.getSession().setAttribute(SessionVar.WFSHARE_IMPORT_PLAN.name(), (Object)plan);
            Long schemeId = this.getLongParameter(request, SCHEME_ID_PARAM);
            this.addToSession(request, SessionVar.SCHEME_ID, schemeId);
            Long projectId = this.getLongParameter(request, PROJECT_ID_PARAM);
            this.addToSession(request, SessionVar.PROJECT_ID, projectId);
            context.put("cancelUrl", this.getCancelUrl(projectId, schemeId, request));
        }
        catch (ValidationException e) {
            this.sendError(response, e, false);
        }
        catch (Exception e) {
            this.sendError(response, e, true);
        }
    }

    private void sendError(HttpServletResponse response, Exception exception, boolean technical) throws IOException {
        this.LOG.debug(exception.getMessage(), (Throwable)exception);
        response.setContentType("application/json;charset=utf-8");
        JSONObject error = new JSONObject();
        try {
            error.put("errorMessage", (Object)exception.getMessage());
            error.put("technical", technical);
        }
        catch (JSONException jsonException) {
            throw new RuntimeException(jsonException);
        }
        response.getWriter().write(error.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUploadZip(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException, ValidationException {
        if (!this.isSystemAdmin()) {
            throw new ValidationException(this.i18n.getText("wfshare.error.not.sys.admin"));
        }
        this.clearSessionAttributes(request.getSession());
        SharedWorkflowImportPlan plan = null;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            try {
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory(0x500000, null));
                upload.setSizeMax(0x500000L);
                List fileItems = upload.parseRequest(request);
                Long schemeId = null;
                Long projectId = null;
                for (FileItem item : fileItems) {
                    String fieldName = item.getFieldName();
                    if (!item.isFormField()) {
                        String fileName = item.getName();
                        request.getSession().setAttribute(SessionVar.WFSHARE_WORKFLOW_NAME.name(), (Object)this.createWorkflowNameFromFilename(fileName));
                        InputStream is = item.getInputStream();
                        try {
                            plan = this.createPlan(this.factory.bundle(is, WorkflowBundle.BundleSource.MANUAL));
                            continue;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)is);
                            continue;
                        }
                    }
                    if (PROJECT_ID_PARAM.equals(fieldName)) {
                        projectId = this.parseLong(item.getString());
                        this.addToSession(request, SessionVar.PROJECT_ID, projectId);
                        continue;
                    }
                    if (SCHEME_ID_PARAM.equals(fieldName)) {
                        schemeId = this.parseLong(item.getString());
                        this.addToSession(request, SessionVar.SCHEME_ID, schemeId);
                        continue;
                    }
                    throw new ValidationException(this.i18n.getText("wfshare.exception.uploading.by.field.not.supported"));
                }
                context.put("cancelUrl", this.getCancelUrl(projectId, schemeId, request));
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                throw new IOException(this.i18n.getText("wfshare.exception.workflow.too.big"), e);
            }
            catch (FileUploadException e) {
                throw new IOException(e.getMessage(), e);
            }
        } else {
            throw new ValidationException(this.i18n.getText("wfshare.exception.not.a.multipart.form.request"));
        }
        request.getSession().setAttribute(SessionVar.WFSHARE_IMPORT_PLAN.name(), plan);
        response.sendRedirect(ServletMapping.IMPORT_SET_NAME.getPath());
    }

    private Long getLongParameter(HttpServletRequest request, String name) throws ValidationException {
        return this.parseLong(request.getParameter(name));
    }

    private Long parseLong(String longString) throws ValidationException {
        if (StringUtils.isEmpty((String)longString)) {
            return null;
        }
        if (!StringUtils.isNumeric((String)longString)) {
            throw new ValidationException(this.i18n.getText("wfshare.exception.import.invalid.id"));
        }
        return Long.parseLong(longString);
    }

    private void addToSession(HttpServletRequest request, SessionVar sessionVar, Object value) {
        request.getSession().setAttribute(sessionVar.name(), value);
    }

    private SharedWorkflowImportPlan createPlan(WorkflowBundle bundle) {
        return new SharedWorkflowImportPlan(this.pluginAccessor, bundle);
    }

    private void showChooseName(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws DataNotFoundInSessionException, IOException {
        SharedWorkflowImportPlan plan = this.getPlan(request);
        String workflowName = (String)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_WORKFLOW_NAME.name());
        this.showChooseName(response, context, plan, workflowName);
    }

    private void showChooseName(HttpServletResponse response, Map<String, Object> context, SharedWorkflowImportPlan plan, String workflowName) throws IOException {
        plan.setWorkflowName(workflowName);
        context.put("suggestedWorkflowName", workflowName);
        this.setNavigationPaths(context, ServletMapping.IMPORT_SET_NAME);
        this.renderer.render(ServletMapping.IMPORT_SET_NAME.getResultTemplate(), context, (Writer)response.getWriter());
    }

    public void doSetName(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws DataNotFoundInSessionException, IOException {
        SimpleErrorCollection errorCollection;
        SharedWorkflowImportPlan plan = this.getPlan(request);
        String sessionName = (String)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_WORKFLOW_NAME.name());
        String chosenName = request.getParameter(WF_NAME_FIELD_NAME);
        if (null == chosenName && null != sessionName) {
            chosenName = sessionName;
        }
        if (WorkflowUtil.isAcceptableName((String)chosenName, (String)WF_NAME_FIELD_NAME, (ErrorCollection)(errorCollection = new SimpleErrorCollection())) && this.workflowManager.getWorkflow(chosenName) != null) {
            errorCollection.addError(WF_NAME_FIELD_NAME, this.i18n.getText("wfshare.import.screen.name.error.exists"));
        }
        if (errorCollection.getErrors().containsKey(WF_NAME_FIELD_NAME)) {
            context.put("errorMessage", errorCollection.getErrors().get(WF_NAME_FIELD_NAME));
            this.showChooseName(response, context, plan, chosenName);
        } else {
            plan.setWorkflowName(chosenName);
            request.getSession().setAttribute(SessionVar.WFSHARE_WORKFLOW_NAME.name(), (Object)chosenName);
            response.sendRedirect(ServletMapping.IMPORT_MAP_STATUSES.getPath());
        }
    }

    private void showMapStatuses(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws DataNotFoundInSessionException, IOException {
        SharedWorkflowImportPlan plan = this.getPlan(request);
        Map<String, StatusMapping> statusHolders = (Map<String, StatusMapping>)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_STATUS_HOLDERS.name());
        if (null == statusHolders) {
            statusHolders = this.workflowStatusHelper.getStatusHolders(plan.getWorkflowXml(), plan.getStatusInfo());
            request.getSession().setAttribute(SessionVar.WFSHARE_STATUS_HOLDERS.name(), statusHolders);
        }
        context.put("jiraStatuses", this.getJiraStatuses());
        context.put("statusHolders", Ordering.from(StatusMapping.OLD_NAME_ORDER).sortedCopy(statusHolders.values()));
        this.addXsrfToken(context, request);
        this.setNavigationPaths(context, ServletMapping.IMPORT_MAP_STATUSES);
        this.renderer.render(ServletMapping.IMPORT_MAP_STATUSES.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private void doMapStatuses(HttpServletRequest request, HttpServletResponse response) throws DataNotFoundInSessionException, ValidationException, IOException {
        List<StatusMapping> statusMappings;
        SharedWorkflowImportPlan plan = this.getPlan(request);
        Map statusHolders = (Map)this.getSessionAttribute(request, SessionVar.WFSHARE_STATUS_HOLDERS.name(), this.i18n.getText("wfshare.exception.status.holders.not.found.in.session"));
        Map<String, String[]> statusMap = this.getStatusParams(request);
        if (null != statusMap && !statusMap.isEmpty()) {
            statusMappings = this.createStatusMappings(statusHolders, statusMap);
            request.getSession().setAttribute(SessionVar.WFSHARE_STATUS_MAPPING.name(), statusMappings);
        } else {
            statusMappings = (List<StatusMapping>)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_STATUS_MAPPING.name());
        }
        plan.setStatusMappings(statusMappings);
        response.sendRedirect(ServletMapping.IMPORT_VIEW_SUMMARY.getPath() + "?atl_token=" + request.getParameter("atl_token"));
    }

    private void showSummary(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException, DataNotFoundInSessionException, ServletException {
        boolean nothingToCreate;
        SharedWorkflowImportPlan plan = this.getPlan(request);
        ImmutableList newStatuses = Ordering.natural().onResultOf((Function)new Function<SimpleStatus, String>(){

            public String apply(SimpleStatus simpleStatus) {
                return simpleStatus.getName();
            }
        }).immutableSortedCopy(Iterables.transform((Iterable)Iterables.filter(plan.getStatusMappings(), (Predicate)new Predicate<StatusMapping>(){

            public boolean apply(StatusMapping statusMapping) {
                return statusMapping.isNewStatus();
            }
        }), (Function)new Function<StatusMapping, SimpleStatus>(){

            public SimpleStatus apply(StatusMapping statusMapping) {
                return ImportWizardHandler.this.workflowStatusHelper.getSimpleStatusFromMapping(statusMapping);
            }
        }));
        ImmutableList plugins = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).immutableSortedCopy(Iterables.transform(plan.getPluginInfo(), WorkflowExtensionsPluginInfo.GET_NAME));
        ImmutableList screens = Ordering.from(ScreenInfo.ORDER_NAME).immutableSortedCopy(Iterables.transform(plan.getScreenInfo(), (Function)new Function<ScreenInfo, ScreenInfo>(){

            public ScreenInfo apply(ScreenInfo screenInfo) {
                return new ScreenInfo(screenInfo.getOriginalId(), ImportWizardHandler.this.screenCreator.getValidName(screenInfo.getName()), screenInfo.getDescription(), screenInfo.getTabs());
            }
        }));
        List<CustomFieldBean> enabledFields = this.getFields(plan.getAllowedEnabledCustomFields(this.pluginAccessor));
        List<CustomFieldBean> disabledFields = this.getFields(plan.getAllowedDisabledCustomFields(this.pluginAccessor));
        boolean bl = nothingToCreate = newStatuses.isEmpty() && screens.isEmpty() && enabledFields.isEmpty();
        if (nothingToCreate) {
            this.doImport(request, response);
        } else {
            context.put("workflowName", plan.getWorkflowName());
            context.put("enabledFields", enabledFields);
            context.put("disabledFields", disabledFields);
            context.put("newStatuses", newStatuses);
            context.put("statusLozengesEnabled", this.statusService.isStatusAsLozengeEnabled());
            context.put("screens", screens);
            context.put("plugins", plugins);
            context.put("isSysAdmin", this.isSystemAdmin());
            this.addXsrfToken(context, request);
            this.setNavigationPaths(context, ServletMapping.IMPORT_WORKFLOW, ServletMapping.IMPORT_MAP_STATUSES);
            this.renderer.render(ServletMapping.IMPORT_VIEW_SUMMARY.getResultTemplate(), context, (Writer)response.getWriter());
        }
    }

    private List<CustomFieldBean> getFields(List<CustomFieldInfo> info) {
        return Ordering.natural().immutableSortedCopy(Iterables.transform(info, (Function)new Function<CustomFieldInfo, CustomFieldBean>(){

            public CustomFieldBean apply(CustomFieldInfo input) {
                CustomFieldType customFieldType = ImportWizardHandler.this.getCustomFieldType(input.getTypeModuleKey());
                String type = customFieldType == null ? null : customFieldType.getName();
                String description = customFieldType == null ? null : customFieldType.getDescription();
                String key = customFieldType == null ? null : customFieldType.getDescriptor().getCompleteKey();
                return new CustomFieldBean(input.getName(), type, description, key);
            }
        }));
    }

    private CustomFieldType getCustomFieldType(String key) {
        ModuleDescriptor module = this.pluginAccessor.getPluginModule(key);
        if (module instanceof CustomFieldTypeModuleDescriptor) {
            return (CustomFieldType)module.getModule();
        }
        return null;
    }

    private void doImport(HttpServletRequest request, HttpServletResponse response) throws IOException, DataNotFoundInSessionException, ServletException {
        if (this.checkXsrf(request, response)) {
            return;
        }
        if (this.enforceAdminLoginForImport(request, response)) {
            return;
        }
        JiraWorkflowSharingImporter importer = this.importerFactory.newImporter();
        SharedWorkflowImportPlan plan = this.getPlan(request);
        importer.importWorkflow(plan);
        response.sendRedirect(ServletMapping.IMPORT_WORKFLOW_SUCCESS.getPath());
    }

    private void showSuccess(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException, DataNotFoundInSessionException {
        SharedWorkflowImportPlan plan = this.getPlan(request);
        context.put("source", (Object)plan.getSource());
        String notes = plan.getNotes();
        if (notes != null) {
            context.put("notes", notes);
            int rowsInNotes = notes.split("\r\n|\r|\n").length;
            int rowsInNotesContainer = Math.max(rowsInNotes, 5);
            context.put("rowsInNotesContainer", rowsInNotesContainer);
        }
        String cancelUrl = (String)context.get("cancelUrl");
        cancelUrl = cancelUrl + "#workflowName=" + this.encodeUrl(plan.getWorkflowName());
        context.put("cancelUrl", cancelUrl);
        this.clearSessionAttributes(request.getSession());
        this.renderer.render(ServletMapping.IMPORT_WORKFLOW_SUCCESS.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private Long getSessionVar(HttpServletRequest request, SessionVar sessionVar) {
        return (Long)this.getSessionAttributeOrNull(request, sessionVar.name());
    }

    private boolean enforceAdminLoginForImport(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
        catch (WebSudoSessionException wse) {
            response.sendRedirect(request.getContextPath() + "/secure/admin/WebSudoAuthenticate!default.jspa?webSudoDestination=" + this.encodeUrl(request.getServletPath() + request.getPathInfo() + "?atl_token=" + this.getXsrfToken(request)));
            return true;
        }
        return false;
    }

    private SharedWorkflowImportPlan getPlan(HttpServletRequest request) throws DataNotFoundInSessionException {
        SharedWorkflowImportPlan plan = this.getPlanOrNull(request);
        if (plan != null) {
            return plan;
        }
        throw new DataNotFoundInSessionException();
    }

    private SharedWorkflowImportPlan getPlanOrNull(HttpServletRequest request) {
        return (SharedWorkflowImportPlan)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_IMPORT_PLAN.name());
    }

    private List<StatusMapping> createStatusMappings(Map<String, StatusMapping> statusHolders, Map<String, String[]> statusParams) throws ValidationException {
        ArrayList<StatusMapping> mappings = new ArrayList<StatusMapping>();
        if (!statusParams.isEmpty()) {
            for (Map.Entry<String, String[]> entry : statusParams.entrySet()) {
                String oldId = StringUtils.substringAfterLast((String)entry.getKey(), (String)"-");
                if (!statusHolders.containsKey(oldId)) {
                    throw new ValidationException(this.i18n.getText("wfshare.exception.unknown.status.id", new Serializable[]{oldId}));
                }
                String newId = entry.getValue()[0];
                StatusMapping oldMappingEntry = statusHolders.get(oldId);
                String originalName = oldMappingEntry.getOriginalName();
                Long statusCategoryId = oldMappingEntry.getStatusCategoryId();
                if (!newId.equals(oldMappingEntry.getNewId())) {
                    oldMappingEntry.setNewId(newId);
                }
                String newName = newId.equals("-1") ? oldMappingEntry.getNewName() : this.workflowStatusHelper.getNameForStatusId(newId);
                mappings.add(new StatusMapping(oldId, originalName, newId, newName, statusCategoryId));
            }
        }
        return mappings;
    }

    private Map<String, String[]> getStatusParams(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return ImmutableMap.copyOf((Map)Maps.filterKeys((Map)parameterMap, (Predicate)new Predicate<String>(){

            public boolean apply(String key) {
                return key.startsWith(ImportWizardHandler.PARAM_STATUS_FOR_PREFIX);
            }
        }));
    }

    private String createWorkflowNameFromFilename(String fileName) {
        String workflowName;
        String suggestedName = workflowName = WordUtils.capitalizeFully((String)FilenameUtils.removeExtension((String)fileName).replaceAll("[_:\\\\/*?|<>-]", " "));
        if (this.workflowManager.workflowExists(workflowName)) {
            int x = 2;
            while (this.workflowManager.workflowExists(suggestedName)) {
                suggestedName = this.i18n.getText("wfshare.import.prefix", new Serializable[]{String.valueOf(x), workflowName});
                ++x;
            }
        }
        return suggestedName;
    }

    public List<Status> getJiraStatuses() {
        return this.workflowStatusHelper.getJiraStatuses();
    }

    private void setNavigationPaths(Map<String, Object> context, ServletMapping servletMapping) {
        this.setNavigationPaths(context, servletMapping, servletMapping.previous());
    }

    private void setNavigationPaths(Map<String, Object> context, ServletMapping next, ServletMapping previous) {
        String nextPath = "/plugins/servlet/wfshare-import/" + next.getPath();
        String backPath = "";
        if (null != previous) {
            backPath = "/plugins/servlet/wfshare-import/" + previous.getPath();
        }
        context.put("nextUrl", this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl() + nextPath);
        context.put("backUrl", this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl() + backPath);
    }

    @Override
    protected void clearSessionAttributes(HttpSession session) {
        super.clearSessionAttributes(session);
        for (SessionVar sessionVar : SessionVar.values()) {
            session.removeAttribute(sessionVar.name());
        }
    }

    public SoyTemplateRenderer getSoyRenderer() {
        return ((SoyTemplateRendererProvider)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRendererProvider.class)).getRenderer();
    }

    public static class CustomFieldBean
    implements Comparable<CustomFieldBean> {
        private final String name;
        private final String type;
        private final String description;
        private final String key;

        public CustomFieldBean(String name, String type, String description, String key) {
            this.name = name;
            this.type = type;
            this.description = description;
            this.key = key;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public int compareTo(CustomFieldBean o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }

    public static enum SessionVar {
        WFSHARE_IMPORT_PLAN,
        WFSHARE_WORKFLOW_NAME,
        WFSHARE_STATUS_HOLDERS,
        WFSHARE_STATUS_MAPPING,
        PROJECT_ID,
        SCHEME_ID;

    }
}

