/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.plugins.workflow.sharing.importer.ValidNameGenerator;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.ScreenCreator;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenItemInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenTabInfo;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ScreenCreatorImpl
implements ScreenCreator {
    private final FieldScreenManager fieldScreenManager;
    private final ValidNameGenerator validNameGenerator;

    @Autowired
    public ScreenCreatorImpl(FieldScreenManager fieldScreenManager, ValidNameGenerator validNameGenerator) {
        this.fieldScreenManager = fieldScreenManager;
        this.validNameGenerator = validNameGenerator;
    }

    @Override
    public void removeScreen(Long screenId) {
        this.fieldScreenManager.removeFieldScreen(screenId);
    }

    @Override
    public FieldScreen createScreen(ScreenInfo screenInfo) {
        String validName = this.getValidName(screenInfo.getName());
        FieldScreenImpl screen = new FieldScreenImpl(this.fieldScreenManager);
        screen.setName(validName);
        screen.setDescription(screenInfo.getDescription());
        screen.store();
        return screen;
    }

    @Override
    public void addScreenTabs(FieldScreen screen, ScreenInfo screenInfo, Map<String, String> createdFieldsMapping) {
        for (ScreenTabInfo tabInfo : screenInfo.getTabs()) {
            FieldScreenTab tab = screen.addTab(tabInfo.getName());
            tab.setPosition(tabInfo.getPosition().intValue());
            List sortedItems = Ordering.from((Comparator)new Comparator<ScreenItemInfo>(){

                @Override
                public int compare(ScreenItemInfo o1, ScreenItemInfo o2) {
                    return o1.getPosition().compareTo(o2.getPosition());
                }
            }).sortedCopy(tabInfo.getItems());
            int position = 0;
            for (ScreenItemInfo itemInfo : sortedItems) {
                if (itemInfo.getFieldId().startsWith("customfield_") && !createdFieldsMapping.containsKey(itemInfo.getFieldId())) continue;
                String newId = itemInfo.getFieldId();
                if (itemInfo.getFieldId().startsWith("customfield_")) {
                    newId = createdFieldsMapping.get(itemInfo.getFieldId());
                }
                tab.addFieldScreenLayoutItem(newId, position);
                ++position;
            }
        }
    }

    @Override
    public String getValidName(String originalName) {
        return this.validNameGenerator.getValidName(originalName, 255, new Function<String, Boolean>(){

            public Boolean apply(String screenName) {
                return ScreenCreatorImpl.this.screenNameAlreadyExists(screenName);
            }
        });
    }

    private boolean screenNameAlreadyExists(final String name) {
        return !ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.fieldScreenManager.getFieldScreens(), (Predicate)new Predicate<FieldScreen>(){

            public boolean apply(FieldScreen fieldScreen) {
                return name.equals(fieldScreen.getName());
            }
        })).isEmpty();
    }
}

