/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.GlobalIssueContext;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.CustomFieldCreator;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.OptionInfo;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class CustomFieldCreatorImpl
implements CustomFieldCreator {
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final OptionsManager optionsManager;

    @Autowired
    public CustomFieldCreatorImpl(CustomFieldManager customFieldManager, FieldConfigSchemeManager fieldConfigSchemeManager, OptionsManager optionsManager) {
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.optionsManager = optionsManager;
    }

    @Override
    public CustomField createCustomField(CustomFieldInfo fieldInfo) throws GenericEntityException {
        CustomFieldType cfType = this.customFieldManager.getCustomFieldType(fieldInfo.getTypeModuleKey());
        CustomFieldSearcher searcher = null;
        if (StringUtils.isNotBlank((String)fieldInfo.getSearcherModuleKey())) {
            searcher = this.customFieldManager.getCustomFieldSearcher(fieldInfo.getSearcherModuleKey());
        }
        ArrayList<Object> issueTypes = new ArrayList<Object>(1);
        issueTypes.add(null);
        CustomField customField = this.customFieldManager.createCustomField(fieldInfo.getName(), fieldInfo.getDescription(), cfType, searcher, Arrays.asList(GlobalIssueContext.getInstance()), issueTypes);
        if (fieldInfo.getOptions() != null) {
            JiraContextNode issueContext = GlobalIssueContext.getInstance();
            FieldConfig fieldConfig = customField.getRelevantConfig((IssueContext)issueContext);
            for (OptionInfo optionInfo : fieldInfo.getOptions()) {
                this.addOptions(optionInfo, null, fieldConfig);
            }
        }
        return customField;
    }

    private void addOptions(OptionInfo optionInfo, Long parentOptionId, FieldConfig fieldConfig) {
        Option option = this.optionsManager.createOption(fieldConfig, parentOptionId, Long.valueOf(optionInfo.getSequence()), optionInfo.getValue());
        if (option.getChildOptions() != null) {
            for (OptionInfo childOptionInfo : optionInfo.getChildOptions()) {
                this.addOptions(childOptionInfo, option.getOptionId(), fieldConfig);
            }
        }
    }

    @Override
    public void removeCustomFieldAndSchemes(CustomField field) throws RemoveException {
        List schemes = field.getConfigurationSchemes();
        for (FieldConfigScheme scheme : schemes) {
            this.fieldConfigSchemeManager.removeFieldConfigScheme(scheme.getId());
        }
        this.customFieldManager.removeCustomField(field);
    }
}

