/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.plugins.workflow.sharing.WorkflowSharingFiles;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.WorkflowExtensionsPluginInfo;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.plugins.workflow.sharing.util.IOSupport;
import com.atlassian.jira.plugins.workflow.sharing.util.LimitedInputStream;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleParser {
    private final Logger log = LoggerFactory.getLogger(BundleParser.class);
    private final ErrorMessageProvider errorMessageProvider;
    private final List<EntryHandler> handlerList;
    private final long maxStream;
    private final long maxEntry;

    public BundleParser(ErrorMessageProvider errorMessageProvider) {
        this(errorMessageProvider, 0x500000L, 0x100000L);
    }

    public BundleParser(ErrorMessageProvider errorMessageProvider, long maxStream, long maxEntry) {
        this.errorMessageProvider = errorMessageProvider;
        ObjectMapper mapper = new ObjectMapper();
        mapper.getJsonFactory().configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        this.handlerList = ImmutableList.of((Object)new WorkflowHandler(), (Object)new AnnotationsHandler(), (Object)new LayoutHandler(), (Object)new LayoutV2Handler(), (Object)new NotesHandler(), (Object)new ScreensHandler(mapper), (Object)new StatusesHandler(mapper), (Object)new CustomFieldHandler(mapper), (Object)new PluginsFieldHandler(mapper), (Object)new PluginsDirHandler());
        this.maxStream = maxStream;
        this.maxEntry = maxEntry;
    }

    public Builder parse(InputStream stream, boolean ignoreUnknownFiles) throws IOException, ValidationException {
        ZipEntry entry;
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new IgnoreCloseInputStream(new LimitedInputStream(stream, this.maxStream)));
            entry = zis.getNextEntry();
        }
        catch (ZipException exception) {
            IOUtils.closeQuietly(zis);
            throw new ValidationException(this.errorMessageProvider.notZip());
        }
        catch (LimitedInputStream.StreamTooBigException e) {
            throw new ValidationException(this.errorMessageProvider.bundleEntryTooBig(e.getSize(), e.getMaxSize()));
        }
        if (entry == null) {
            throw new ValidationException(this.errorMessageProvider.notZip());
        }
        Builder builder = new Builder();
        try {
            do {
                if (entry.getSize() > 0L && entry.getSize() > this.maxEntry) {
                    throw new ValidationException(this.errorMessageProvider.bundleEntryTooBig(entry.getSize(), this.maxEntry));
                }
                boolean handled = false;
                try {
                    LimitedInputStream limitedStream = new LimitedInputStream(zis, this.maxEntry);
                    for (EntryHandler entryHandler : this.handlerList) {
                        if (!entryHandler.handle(entry, limitedStream, builder, this.errorMessageProvider)) continue;
                        handled = true;
                        break;
                    }
                }
                catch (LimitedInputStream.StreamTooBigException e) {
                    throw new ValidationException(this.errorMessageProvider.bundleEntryTooBig(e.getSize(), e.getMaxSize()));
                }
                if (handled) continue;
                if (!ignoreUnknownFiles) {
                    throw new ValidationException(this.errorMessageProvider.unknownFile(entry.getName()));
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Ignoring zip entry '{}'.", (Object)entry);
            } while ((entry = zis.getNextEntry()) != null);
        }
        catch (LimitedInputStream.StreamTooBigException e) {
            throw new ValidationException(this.errorMessageProvider.bundleEntryTooBig(e.getSize(), e.getMaxSize()));
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
        if (builder.getWorkflowXml() == null) {
            throw new ValidationException(this.errorMessageProvider.noWorkflowXml());
        }
        return builder;
    }

    private static <T> List<T> uniqueList(Iterable<T> items, Function<? super T, ?> toKey) {
        if (items == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet object = Sets.newHashSet();
        for (T item : items) {
            if (!object.add(toKey.apply(item))) continue;
            builder.add(item);
        }
        return builder.build();
    }

    public long getMaxStream() {
        return this.maxStream;
    }

    private static final class IgnoreCloseInputStream
    extends FilterInputStream {
        protected IgnoreCloseInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static class PluginsFieldHandler
    extends JsonHandler<List<WorkflowExtensionsPluginInfo>> {
        private PluginsFieldHandler(ObjectMapper mapper) {
            super(WorkflowSharingFiles.PLUGINS, WorkflowExtensionsPluginInfo.LIST_TYPE, mapper);
        }

        @Override
        void addObject(List<WorkflowExtensionsPluginInfo> o, Builder builder) {
            builder.setPluginInfo((List<WorkflowExtensionsPluginInfo>)ImmutableList.copyOf(o));
        }
    }

    private static class CustomFieldHandler
    extends JsonHandler<List<CustomFieldInfo>> {
        private CustomFieldHandler(ObjectMapper mapper) {
            super(WorkflowSharingFiles.CUSTOM_FIELDS, CustomFieldInfo.LIST_TYPE, mapper);
        }

        @Override
        void addObject(List<CustomFieldInfo> o, Builder builder) {
            builder.setCustomFieldInfos((List<CustomFieldInfo>)ImmutableList.copyOf(o));
        }
    }

    private static class StatusesHandler
    extends JsonHandler<List<StatusInfo>> {
        private StatusesHandler(ObjectMapper mapper) {
            super(WorkflowSharingFiles.STATUSES, StatusInfo.LIST_TYPE, mapper);
        }

        @Override
        void addObject(List<StatusInfo> o, Builder builder) {
            builder.setStatusInfoList((List<StatusInfo>)ImmutableList.copyOf(o));
        }
    }

    private static class ScreensHandler
    extends JsonHandler<List<ScreenInfo>> {
        private ScreensHandler(ObjectMapper mapper) {
            super(WorkflowSharingFiles.SCREENS, ScreenInfo.LIST_TYPE, mapper);
        }

        @Override
        void addObject(List<ScreenInfo> o, Builder builder) {
            builder.setScreenInfoList((List<ScreenInfo>)ImmutableList.copyOf(o));
        }
    }

    private static abstract class JsonHandler<T>
    implements EntryHandler {
        private final WorkflowSharingFiles file;
        private final TypeReference<T> type;
        private final ObjectMapper mapper;

        private JsonHandler(WorkflowSharingFiles file, TypeReference<T> type, ObjectMapper mapper) {
            this.file = file;
            this.type = type;
            this.mapper = mapper;
        }

        @Override
        public boolean handle(ZipEntry entry, InputStream input, Builder builder, ErrorMessageProvider errorMessageProvider) throws IOException, ValidationException {
            Object o;
            if (!this.file.getPath().equals(entry.getName())) {
                return false;
            }
            try {
                o = this.mapper.readValue(input, this.type);
            }
            catch (JsonProcessingException e) {
                throw new ValidationException(errorMessageProvider.invalidJson(entry.getName()));
            }
            if (o != null) {
                this.addObject(o, builder);
            }
            return true;
        }

        abstract void addObject(T var1, Builder var2);
    }

    private static class WorkflowHandler
    extends StringEntryHandler {
        private WorkflowHandler() {
            super(WorkflowSharingFiles.WORKFLOW);
        }

        @Override
        void addString(String string, Builder builder) {
            builder.setWorkflowXml(string);
        }
    }

    private static class NotesHandler
    extends StringEntryHandler {
        private NotesHandler() {
            super(WorkflowSharingFiles.NOTES);
        }

        @Override
        void addString(String string, Builder builder) {
            builder.setNotes(string);
        }
    }

    private static class LayoutV2Handler
    extends StringEntryHandler {
        private LayoutV2Handler() {
            super(WorkflowSharingFiles.LAYOUT_V2);
        }

        @Override
        void addString(String string, Builder builder) {
            builder.setLayoutV2(string);
        }
    }

    private static class LayoutHandler
    extends StringEntryHandler {
        private LayoutHandler() {
            super(WorkflowSharingFiles.LAYOUT);
        }

        @Override
        void addString(String string, Builder builder) {
            builder.setLayout(string);
        }
    }

    private static class AnnotationsHandler
    extends StringEntryHandler {
        private AnnotationsHandler() {
            super(WorkflowSharingFiles.ANNOTATION);
        }

        @Override
        void addString(String string, Builder builder) {
            builder.setAnnotations(string);
        }
    }

    private static abstract class StringEntryHandler
    implements EntryHandler {
        private final WorkflowSharingFiles file;

        private StringEntryHandler(WorkflowSharingFiles file) {
            this.file = file;
        }

        @Override
        public boolean handle(ZipEntry entry, InputStream input, Builder builder, ErrorMessageProvider errorMessageProvider) throws IOException {
            if (entry.getName().equals(this.file.getPath())) {
                String str = IOSupport.readString(input);
                if (str != null) {
                    this.addString(StringUtils.stripToNull((String)str), builder);
                }
                return true;
            }
            return false;
        }

        abstract void addString(String var1, Builder var2);
    }

    private static class PluginsDirHandler
    implements EntryHandler {
        private PluginsDirHandler() {
        }

        @Override
        public boolean handle(ZipEntry entry, InputStream input, Builder builder, ErrorMessageProvider errorMessageProvider) throws IOException, ValidationException {
            return entry.getName().startsWith(WorkflowSharingFiles.PLUGINS_DIR.getPath());
        }
    }

    private static interface EntryHandler {
        public boolean handle(ZipEntry var1, InputStream var2, Builder var3, ErrorMessageProvider var4) throws IOException, ValidationException;
    }

    private static class DefaultWorkflowBundle
    implements WorkflowBundle {
        private final WorkflowBundle.BundleSource source;
        private final String workflowXml;
        private final String layout;
        private final String layoutV2;
        private final String annotations;
        private final List<WorkflowExtensionsPluginInfo> pluginInfo;
        private final List<CustomFieldInfo> customFieldInfo;
        private final List<StatusInfo> statusInfo;
        private final List<ScreenInfo> screenInfo;
        private final String notes;

        private DefaultWorkflowBundle(Builder builder) {
            this.annotations = builder.getAnnotations();
            this.source = builder.getSource();
            this.workflowXml = builder.getWorkflowXml();
            this.layout = builder.getLayout();
            this.layoutV2 = builder.getLayoutV2();
            this.notes = builder.getNotes();
            this.statusInfo = builder.getStatusInfoList();
            this.pluginInfo = BundleParser.uniqueList(builder.getPluginInfo(), WorkflowExtensionsPluginInfo.GET_KEY);
            this.customFieldInfo = BundleParser.uniqueList(builder.getCustomFieldInfos(), CustomFieldInfo.GET_ORIGINAL_ID);
            this.screenInfo = BundleParser.uniqueList(builder.getScreenInfoList(), ScreenInfo.GET_ORIGINAL_ID);
        }

        @Override
        public WorkflowBundle.BundleSource getSource() {
            return this.source;
        }

        @Override
        public String getWorkflowXml() {
            return this.workflowXml;
        }

        @Override
        public String getLayout() {
            return this.layout;
        }

        @Override
        public String getLayoutV2() {
            return this.layoutV2;
        }

        @Override
        public String getAnnotations() {
            return this.annotations;
        }

        @Override
        public Iterable<WorkflowExtensionsPluginInfo> getPluginInfo() {
            return this.pluginInfo;
        }

        @Override
        public Iterable<CustomFieldInfo> getCustomFieldInfo() {
            return this.customFieldInfo;
        }

        @Override
        public Iterable<StatusInfo> getStatusInfo() {
            return this.statusInfo;
        }

        @Override
        public Iterable<ScreenInfo> getScreenInfo() {
            return this.screenInfo;
        }

        @Override
        public String getNotes() {
            return this.notes;
        }
    }

    static class Builder {
        private WorkflowBundle.BundleSource source;
        private String workflowXml;
        private String layout;
        private String layoutV2;
        private String annotations;
        private List<WorkflowExtensionsPluginInfo> pluginInfo = ImmutableList.of();
        private List<CustomFieldInfo> customFieldInfos = ImmutableList.of();
        private List<StatusInfo> statusInfoList = ImmutableList.of();
        private List<ScreenInfo> screenInfoList = ImmutableList.of();
        private String notes;

        Builder() {
        }

        public Builder setAnnotations(String annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder setCustomFieldInfos(List<CustomFieldInfo> customFieldInfos) {
            this.customFieldInfos = customFieldInfos;
            return this;
        }

        public Builder setPluginInfo(List<WorkflowExtensionsPluginInfo> pluginInfo) {
            this.pluginInfo = pluginInfo;
            return this;
        }

        public Builder setLayout(String layout) {
            this.layout = layout;
            return this;
        }

        public Builder setLayoutV2(String layoutV2) {
            this.layoutV2 = layoutV2;
            return this;
        }

        public Builder setNotes(String notes) {
            this.notes = notes;
            return this;
        }

        public Builder setScreenInfoList(List<ScreenInfo> screenInfoList) {
            this.screenInfoList = screenInfoList;
            return this;
        }

        public Builder setStatusInfoList(List<StatusInfo> statusInfoList) {
            this.statusInfoList = statusInfoList;
            return this;
        }

        public Builder setSource(WorkflowBundle.BundleSource source) {
            this.source = source;
            return this;
        }

        public Builder setWorkflowXml(String workflowXml) {
            this.workflowXml = workflowXml;
            return this;
        }

        public String getAnnotations() {
            return this.annotations;
        }

        public List<CustomFieldInfo> getCustomFieldInfos() {
            return this.customFieldInfos;
        }

        public List<WorkflowExtensionsPluginInfo> getPluginInfo() {
            return this.pluginInfo;
        }

        public String getLayout() {
            return this.layout;
        }

        public String getLayoutV2() {
            return this.layoutV2;
        }

        public String getNotes() {
            return this.notes;
        }

        public List<ScreenInfo> getScreenInfoList() {
            return this.screenInfoList;
        }

        public List<StatusInfo> getStatusInfoList() {
            return this.statusInfoList;
        }

        public WorkflowBundle.BundleSource getSource() {
            return this.source;
        }

        public String getWorkflowXml() {
            return this.workflowXml;
        }

        public DefaultWorkflowBundle build() {
            return new DefaultWorkflowBundle(this);
        }
    }

    public static interface ErrorMessageProvider {
        public String notZip();

        public String bundleEntryTooBig(long var1, long var3);

        public String unknownFile(String var1);

        public String noWorkflowXml();

        public String invalidJson(String var1);
    }
}

