/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer.component;

import com.atlassian.jira.plugins.workflow.sharing.ImportableJiraWorkflow;
import com.atlassian.jira.plugins.workflow.sharing.RemovedItems;
import com.atlassian.jira.plugins.workflow.sharing.WhitelistCheckerImpl;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelperImpl;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.BundleParser;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class BundleChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long maxSize;
        if (args.length == 0) {
            System.err.println("Bundle file is not specified as first argument");
            return;
        }
        String fileName = args[0];
        File bundleFile = new File(fileName);
        if (!bundleFile.exists()) {
            System.err.println("File not found: '" + fileName + "'");
            return;
        }
        BundleParser bundleParser = new BundleParser(new SimpleErrorMessageProvider());
        long bundleSize = bundleFile.length();
        if (bundleSize > (maxSize = bundleParser.getMaxStream())) {
            System.err.println("Validation error: Bundle is too big: " + bundleSize + ". Max allowed size is " + maxSize);
            return;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(bundleFile);
            BundleChecker.check(stream, bundleParser);
        }
        catch (FileNotFoundException e) {
            try {
                System.err.println("File not found: '" + fileName + "'");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    private static void check(InputStream stream, BundleParser bundleParser) {
        try {
            BundleParser.Builder builder = bundleParser.parse(stream, false);
            BundleChecker.validatePlugins(builder);
            BundleChecker.validateCustomFields(builder);
            ImportableJiraWorkflow workflow = BundleChecker.validateWorkflowXml(builder);
            BundleChecker.validateActions(workflow);
            System.out.println("Bundle is OK");
        }
        catch (ValidationException e) {
            System.err.println("Validation error: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("I/O error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void validatePlugins(BundleParser.Builder builder) {
        if (CollectionUtils.isNotEmpty(builder.getPluginInfo())) {
            System.out.println("Warning: bundle contains plugins");
        }
    }

    private static void validateCustomFields(BundleParser.Builder builder) {
        List<CustomFieldInfo> illegal = Lists.newArrayList();
        for (CustomFieldInfo info : builder.getCustomFieldInfos()) {
            String fieldPluginKey = StringUtils.stripToEmpty((String)info.getPluginKey());
            if (fieldPluginKey.startsWith("com.atlassian.jira.plugin.system.")) continue;
            illegal.add(info);
        }
        if (!illegal.isEmpty()) {
            illegal = Ordering.from((Comparator)new Comparator<CustomFieldInfo>(){

                @Override
                public int compare(CustomFieldInfo field1, CustomFieldInfo field2) {
                    return field1.getName().compareToIgnoreCase(field2.getName());
                }
            }).sortedCopy((Iterable)illegal);
            System.out.println("Warning: the following custom fields are not allowed to be imported: ");
            for (CustomFieldInfo field : illegal) {
                System.out.println("\t" + field.getName() + " - " + field.getTypeModuleKey());
            }
        }
    }

    private static ImportableJiraWorkflow validateWorkflowXml(BundleParser.Builder builder) throws ValidationException {
        try {
            WorkflowDescriptor workflowDescriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)builder.getWorkflowXml());
            return new ImportableJiraWorkflow("", workflowDescriptor, null);
        }
        catch (FactoryException e) {
            throw new ValidationException("Workflow XML is invalid");
        }
    }

    private static void validateActions(ImportableJiraWorkflow workflow) throws IOException {
        WhitelistCheckerImpl whitelistChecker = new WhitelistCheckerImpl();
        whitelistChecker.afterPropertiesSet();
        WorkflowExtensionsHelperImpl helper = new WorkflowExtensionsHelperImpl(null, null, null, null, null, whitelistChecker);
        RemovedItems removedItems = helper.getRemovedItems((JiraWorkflow)workflow, false);
        if (removedItems.isEmpty()) {
            return;
        }
        System.out.println("Warning: bundle contains the following conditions/validators/post-functions which are not allowed to be imported:");
        for (RemovedItems.ActionRemovedItems actionRemovedItems : removedItems.getActionRemovedItems()) {
            if (actionRemovedItems.isEmpty()) continue;
            System.out.println("\t" + actionRemovedItems.getAction().getName());
            for (String conditionClass : Ordering.natural().sortedCopy(actionRemovedItems.getConditions())) {
                System.out.println("\t\t" + conditionClass);
            }
            for (String validatorClass : Ordering.natural().sortedCopy(actionRemovedItems.getValidators())) {
                System.out.println("\t\t" + validatorClass);
            }
            for (String functionClass : Ordering.natural().sortedCopy(actionRemovedItems.getFunctions())) {
                System.out.println("\t\t" + functionClass);
            }
        }
    }

    private static class SimpleErrorMessageProvider
    implements BundleParser.ErrorMessageProvider {
        private SimpleErrorMessageProvider() {
        }

        @Override
        public String notZip() {
            return "Not a zip file";
        }

        @Override
        public String bundleEntryTooBig(long size, long maxSize) {
            return "Bundle file contains an entry which is too big: " + size + ". Max allowed size is " + maxSize;
        }

        @Override
        public String unknownFile(String fileName) {
            return "Bundle contains an unknown file: " + fileName;
        }

        @Override
        public String invalidJson(String fileName) {
            return "Bundle contains an invalid JSON file: " + fileName;
        }

        @Override
        public String noWorkflowXml() {
            return "Workflow XML not found in bundle";
        }
    }
}

