/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer;

import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowBundle;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.WorkflowExtensionsPluginInfo;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class SharedWorkflowImportPlan
implements Serializable {
    private static final long serialVersionUID = -6834060780888044072L;
    private final WorkflowBundle bundle;
    private final List<CustomFieldInfo> goodCustomFields;
    private volatile List<StatusMapping> statusMappings;
    private volatile String workflowName;

    public SharedWorkflowImportPlan(PluginAccessor pluginAccessor, WorkflowBundle bundle) {
        ArrayList allowed = Lists.newArrayList();
        for (CustomFieldInfo info : bundle.getCustomFieldInfo()) {
            String fieldPluginKey;
            if (pluginAccessor.getPluginModule(info.getTypeModuleKey()) == null || !(fieldPluginKey = StringUtils.stripToEmpty((String)info.getPluginKey())).startsWith("com.atlassian.jira.plugin.system.")) continue;
            allowed.add(info);
        }
        this.goodCustomFields = ImmutableList.copyOf((Collection)allowed);
        this.bundle = bundle;
    }

    public List<StatusMapping> getStatusMappings() {
        return this.statusMappings;
    }

    public void setStatusMappings(List<StatusMapping> statusMappings) {
        this.statusMappings = statusMappings;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public List<CustomFieldInfo> getAllowedEnabledCustomFields(PluginAccessor pluginAccessor) {
        return this.getAllowedCustomFields(new EnabledModulePredicate(pluginAccessor));
    }

    public List<CustomFieldInfo> getAllowedDisabledCustomFields(PluginAccessor pluginAccessor) {
        return this.getAllowedCustomFields((Predicate<CustomFieldInfo>)Predicates.not((Predicate)new EnabledModulePredicate(pluginAccessor)));
    }

    private List<CustomFieldInfo> getAllowedCustomFields(Predicate<CustomFieldInfo> predicate) {
        return ImmutableList.copyOf((Collection)Collections2.filter(this.goodCustomFields, predicate));
    }

    public List<ScreenInfo> getScreenInfo() {
        return ImmutableList.copyOf(this.bundle.getScreenInfo());
    }

    public List<StatusInfo> getStatusInfo() {
        return ImmutableList.copyOf(this.bundle.getStatusInfo());
    }

    public List<WorkflowExtensionsPluginInfo> getPluginInfo() {
        return ImmutableList.copyOf(this.bundle.getPluginInfo());
    }

    public String getNotes() {
        return this.bundle.getNotes();
    }

    public WorkflowBundle.BundleSource getSource() {
        return this.bundle.getSource();
    }

    public String getWorkflowXml() {
        return this.bundle.getWorkflowXml();
    }

    public String getLayout() {
        return this.bundle.getLayout();
    }

    public String getLayoutV2() {
        return this.bundle.getLayoutV2();
    }

    public String getAnnotations() {
        return this.bundle.getAnnotations();
    }

    private static class EnabledModulePredicate
    implements Predicate<CustomFieldInfo> {
        private final PluginAccessor pluginAccessor;

        EnabledModulePredicate(PluginAccessor pluginAccessor) {
            this.pluginAccessor = pluginAccessor;
        }

        public boolean apply(CustomFieldInfo customFieldInfo) {
            return this.pluginAccessor.isPluginModuleEnabled(customFieldInfo.getTypeModuleKey());
        }
    }
}

