/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.importer;

import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflow.sharing.ImportableJiraWorkflow;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowLayoutKeyFinder;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowScreensHelper;
import com.atlassian.jira.plugins.workflow.sharing.importer.JiraWorkflowSharingImporter;
import com.atlassian.jira.plugins.workflow.sharing.importer.SharedWorkflowImportPlan;
import com.atlassian.jira.plugins.workflow.sharing.importer.StatusMapping;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.CustomFieldCreator;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.ScreenCreator;
import com.atlassian.jira.plugins.workflow.sharing.importer.component.WorkflowStatusHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.CustomFieldInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.sysbliss.jira.plugins.workflow.util.WorkflowDesignerPropertySet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JiraWorkflowSharingImporterImpl
implements JiraWorkflowSharingImporter {
    private static final String JIRA_STATUS_ID = "jira.status.id";
    private static final String NEW_STATUS_DEFAULT_ICON = "/images/icons/status_generic.gif";
    private final WorkflowStatusHelper workflowStatusHelper;
    private final WorkflowManager workflowManager;
    private final WorkflowExtensionsHelper workflowExtensionsHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowDesignerPropertySet workflowDesignerPropertySet;
    private final CustomFieldCreator customFieldCreator;
    private final ScreenCreator screenCreator;
    private final WorkflowScreensHelper workflowScreensHelper;
    private final I18nResolver i18n;
    private final WorkflowLayoutKeyFinder workflowLayoutKeyFinder;
    private final PluginAccessor pluginAccessor;

    public JiraWorkflowSharingImporterImpl(WorkflowStatusHelper workflowStatusHelper, WorkflowManager workflowManager, WorkflowExtensionsHelper workflowExtensionsHelper, JiraAuthenticationContext jiraAuthenticationContext, WorkflowDesignerPropertySet workflowDesignerPropertySet, CustomFieldCreator customFieldCreator, ScreenCreator screenCreator, WorkflowScreensHelper workflowScreensHelper, I18nResolver i18n, WorkflowLayoutKeyFinder workflowLayoutKeyFinder, PluginAccessor pluginAccessor) {
        this.workflowStatusHelper = workflowStatusHelper;
        this.workflowManager = workflowManager;
        this.workflowExtensionsHelper = workflowExtensionsHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowDesignerPropertySet = workflowDesignerPropertySet;
        this.customFieldCreator = customFieldCreator;
        this.screenCreator = screenCreator;
        this.workflowScreensHelper = workflowScreensHelper;
        this.i18n = i18n;
        this.workflowLayoutKeyFinder = workflowLayoutKeyFinder;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public JiraWorkflow importWorkflow(SharedWorkflowImportPlan plan) {
        ImportableJiraWorkflow jiraWorkflow;
        Set<Status> createdStatuses = Collections.emptySet();
        Set<CustomField> createdCustomFields = Collections.emptySet();
        Set<FieldScreen> createdScreens = Collections.emptySet();
        try {
            jiraWorkflow = this.getJiraWorkflowFromPlan(plan);
            createdStatuses = this.importStatuses(plan, jiraWorkflow);
            this.workflowExtensionsHelper.removeIllegalComponents((JiraWorkflow)jiraWorkflow);
            CustomFieldCreationResult customFieldCreationResult = this.importCustomFields(plan);
            createdCustomFields = customFieldCreationResult.getCreatedFields();
            ScreenCreationResult screenCreationResult = this.importScreens(plan, customFieldCreationResult.getOldToNewIdMapping());
            createdScreens = screenCreationResult.getCreatedScreens();
            this.updateWorkflowScreenIds(jiraWorkflow, screenCreationResult.getOldToNewIdMapping());
            this.createWorkflow(jiraWorkflow);
            this.importLayoutAndAnnotations(plan);
        }
        catch (Exception e) {
            this.rollback(createdStatuses, createdCustomFields, createdScreens);
            throw new RuntimeException(e.getMessage(), e);
        }
        return jiraWorkflow;
    }

    private ImportableJiraWorkflow getJiraWorkflowFromPlan(SharedWorkflowImportPlan plan) throws Exception {
        try {
            WorkflowDescriptor descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)plan.getWorkflowXml());
            return new ImportableJiraWorkflow(plan.getWorkflowName(), descriptor, this.workflowManager);
        }
        catch (Exception e) {
            throw new Exception(this.i18n.getText("wfshare.exception.unable.to.create.workflow.descriptor"), e);
        }
    }

    private Set<Status> importStatuses(SharedWorkflowImportPlan plan, ImportableJiraWorkflow jiraWorkflow) throws Exception {
        Set<Status> createdStatuses = new HashSet<Status>();
        if (null != plan.getStatusMappings() && !plan.getStatusMappings().isEmpty()) {
            try {
                createdStatuses = this.updateStatuses(jiraWorkflow, plan.getStatusMappings());
            }
            catch (Exception e) {
                throw new Exception(this.i18n.getText("wfshare.exception.unable.to.migrate.statuses"), e);
            }
        }
        return createdStatuses;
    }

    private CustomFieldCreationResult importCustomFields(SharedWorkflowImportPlan plan) throws Exception {
        List<CustomFieldInfo> fieldInfoList;
        try {
            fieldInfoList = plan.getAllowedEnabledCustomFields(this.pluginAccessor);
        }
        catch (Exception e) {
            throw new Exception(this.i18n.getText("wfshare.exception.unable.to.read.custom.field.data"), e);
        }
        CustomFieldCreationResult result = new CustomFieldCreationResult();
        if (fieldInfoList != null && !fieldInfoList.isEmpty()) {
            try {
                result = this.createCustomFields(fieldInfoList);
            }
            catch (Exception e) {
                throw new Exception(this.i18n.getText("wfshare.exception.unable.to.migrate.custom.fields"), e);
            }
        }
        return result;
    }

    private ScreenCreationResult importScreens(SharedWorkflowImportPlan plan, Map<String, String> fieldMappings) throws Exception {
        List<ScreenInfo> screenInfoList;
        try {
            screenInfoList = plan.getScreenInfo();
        }
        catch (Exception e) {
            throw new Exception(this.i18n.getText("wfshare.exception.unable.to.read.screen.data"), e);
        }
        try {
            return this.createScreens(screenInfoList, fieldMappings);
        }
        catch (Exception e) {
            throw new Exception(this.i18n.getText("wfshare.exception.unable.to.migrate.screens"), e);
        }
    }

    private void updateWorkflowScreenIds(ImportableJiraWorkflow jiraWorkflow, Map<Long, Long> oldToNewIdMapping) {
        this.workflowScreensHelper.updateWorkflowScreenIds(jiraWorkflow, oldToNewIdMapping);
        jiraWorkflow.resetFieldScreens();
    }

    private void createWorkflow(ImportableJiraWorkflow jiraWorkflow) throws Exception {
        try {
            this.workflowManager.createWorkflow(this.jiraAuthenticationContext.getUser(), (JiraWorkflow)jiraWorkflow);
        }
        catch (Exception e) {
            throw new Exception(this.i18n.getText("wfshare.exception.unable.to.create.workflow"), e);
        }
    }

    private void importLayoutAndAnnotations(SharedWorkflowImportPlan plan) {
        try {
            if (plan.getLayout() != null) {
                String layoutPropKey = this.workflowLayoutKeyFinder.getActiveLayoutKey(plan.getWorkflowName());
                this.workflowDesignerPropertySet.setProperty(layoutPropKey, plan.getLayout());
            }
            if (plan.getLayoutV2() != null) {
                String layoutV2PropKey = this.workflowLayoutKeyFinder.getActiveLayoutV2Key(plan.getWorkflowName());
                this.workflowDesignerPropertySet.setProperty(layoutV2PropKey, plan.getLayoutV2());
            }
            if (plan.getAnnotations() != null) {
                String annotationPropKey = "jira.jwd.annotation:".concat(plan.getWorkflowName());
                this.workflowDesignerPropertySet.setProperty(annotationPropKey, plan.getAnnotations());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rollback(Set<Status> createdStatuses, Set<CustomField> createdCustomFields, Set<FieldScreen> createdScreens) {
        this.removeStatuses(createdStatuses);
        this.removeCustomFields(createdCustomFields);
        this.removeScreens(createdScreens);
    }

    private void removeStatuses(Set<Status> statuses) {
        for (Status status : statuses) {
            try {
                this.workflowStatusHelper.removeStatus(status.getId());
            }
            catch (Exception exception) {}
        }
    }

    private Set<Status> updateStatuses(ImportableJiraWorkflow jiraWorkflow, List<StatusMapping> statusMappings) throws Exception {
        List steps = jiraWorkflow.getDescriptor().getSteps();
        HashSet createdStatuses = Sets.newHashSet();
        ImmutableMap statusStepMap = Maps.uniqueIndex((Iterable)steps, (Function)new Function<StepDescriptor, String>(){

            public String apply(StepDescriptor stepDescriptor) {
                return (String)stepDescriptor.getMetaAttributes().get(JiraWorkflowSharingImporterImpl.JIRA_STATUS_ID);
            }
        });
        for (StatusMapping mapping : statusMappings) {
            StepDescriptor step;
            if (mapping.getNewId().equals("-1")) {
                try {
                    Status status = this.workflowStatusHelper.createStatus(mapping, NEW_STATUS_DEFAULT_ICON);
                    mapping.setNewId(status.getId());
                    createdStatuses.add(status);
                }
                catch (Exception e) {
                    if (!createdStatuses.isEmpty()) {
                        this.removeStatuses(createdStatuses);
                    }
                    throw new Exception(e);
                }
            }
            if (null == (step = (StepDescriptor)statusStepMap.get(mapping.getOriginalId()))) continue;
            step.getMetaAttributes().put(JIRA_STATUS_ID, mapping.getNewId());
        }
        return createdStatuses;
    }

    private CustomFieldCreationResult createCustomFields(List<CustomFieldInfo> fieldInfoList) throws Exception {
        CustomFieldCreationResult result = new CustomFieldCreationResult();
        for (CustomFieldInfo fieldInfo : fieldInfoList) {
            try {
                CustomField cf = this.customFieldCreator.createCustomField(fieldInfo);
                result.addCustomField(cf);
                result.addMapping(fieldInfo.getOriginalId(), cf.getId());
            }
            catch (Exception e) {
                if (!result.getCreatedFields().isEmpty()) {
                    this.removeCustomFields(result.getCreatedFields());
                }
                throw new Exception(e);
            }
        }
        return result;
    }

    private ScreenCreationResult createScreens(Iterable<ScreenInfo> screenInfoList, Map<String, String> createdFieldsMapping) throws Exception {
        ScreenCreationResult result = new ScreenCreationResult();
        for (ScreenInfo screenInfo : screenInfoList) {
            try {
                FieldScreen screen = this.screenCreator.createScreen(screenInfo);
                result.addScreen(screen);
                result.addMapping(screenInfo.getOriginalId(), screen.getId());
                this.screenCreator.addScreenTabs(screen, screenInfo, createdFieldsMapping);
            }
            catch (Exception e) {
                if (!result.getCreatedScreens().isEmpty()) {
                    this.removeScreens(result.getCreatedScreens());
                }
                throw new Exception(e);
            }
        }
        return result;
    }

    private void removeCustomFields(Set<CustomField> createdFields) {
        for (CustomField field : createdFields) {
            try {
                this.customFieldCreator.removeCustomFieldAndSchemes(field);
            }
            catch (RemoveException removeException) {}
        }
    }

    private void removeScreens(Set<FieldScreen> createdScreens) {
        for (FieldScreen screen : createdScreens) {
            this.screenCreator.removeScreen(screen.getId());
        }
    }

    private class CustomFieldCreationResult {
        private Set<CustomField> createdFields = new HashSet<CustomField>();
        private Map<String, String> oldToNewIdMapping = new HashMap<String, String>();

        private CustomFieldCreationResult() {
        }

        public void addCustomField(CustomField field) {
            this.createdFields.add(field);
        }

        public void addMapping(String oldId, String newId) {
            this.oldToNewIdMapping.put(oldId, newId);
        }

        public Set<CustomField> getCreatedFields() {
            return this.createdFields;
        }

        public Map<String, String> getOldToNewIdMapping() {
            return this.oldToNewIdMapping;
        }
    }

    private class ScreenCreationResult {
        private Set<FieldScreen> createdScreens = new HashSet<FieldScreen>();
        private Map<Long, Long> oldToNewIdMapping = new HashMap<Long, Long>();

        private ScreenCreationResult() {
        }

        public void addScreen(FieldScreen screen) {
            this.createdScreens.add(screen);
        }

        public void addMapping(Long oldId, Long newId) {
            this.oldToNewIdMapping.put(oldId, newId);
        }

        public Set<FieldScreen> getCreatedScreens() {
            return this.createdScreens;
        }

        public Map<Long, Long> getOldToNewIdMapping() {
            return this.oldToNewIdMapping;
        }
    }
}

