/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.file;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.workflow.sharing.file.FileCleaningJobScheduler;
import com.atlassian.jira.plugins.workflow.sharing.file.FileManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={FileCleaningJobScheduler.class})
@Component
public class FileCleaningJobSchedulerImpl
implements FileCleaningJobScheduler {
    private final Logger LOG = LoggerFactory.getLogger(FileCleaningJobSchedulerImpl.class);
    private static final String JOB_KEY = "com.atlassian.jira.plugins.workflow.sharing.file.FileCleaningJob";
    private static final String MAX_AGE_KEY = "MAX_AGE";
    private static final long DEFAULT_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private final PluginScheduler pluginScheduler;
    private boolean isScheduled = false;

    @Autowired
    public FileCleaningJobSchedulerImpl(PluginScheduler pluginScheduler) {
        this.pluginScheduler = pluginScheduler;
    }

    @Override
    public synchronized void start() {
        this.LOG.debug("Adding schedule for FileCleaningJobScheduler.");
        if (!this.isScheduled) {
            this.schedule();
            this.isScheduled = true;
        }
    }

    @Override
    public synchronized void stop() {
        this.LOG.debug("Removing schedule for FileCleaningJobScheduler.");
        if (this.isScheduled) {
            this.unschedule();
            this.isScheduled = false;
        }
    }

    private void schedule() {
        this.LOG.debug("Scheduling deletion of old workflow files to " + DEFAULT_INTERVAL + " minutes");
        HashMap<String, Long> jobData = new HashMap<String, Long>();
        jobData.put(MAX_AGE_KEY, DEFAULT_INTERVAL);
        this.pluginScheduler.scheduleJob(JOB_KEY, FileCleaningJob.class, jobData, new Date(System.currentTimeMillis() + DEFAULT_INTERVAL), DEFAULT_INTERVAL);
    }

    private void unschedule() {
        this.pluginScheduler.unscheduleJob(JOB_KEY);
    }

    @Override
    public long getCurrentMaxAge() {
        return DEFAULT_INTERVAL;
    }

    public static class FileCleaningJob
    implements PluginJob {
        private final Logger LOG = LoggerFactory.getLogger(FileCleaningJob.class);

        public void execute(Map<String, Object> jobDataMap) {
            try {
                Long maxAgeInMs = (Long)jobDataMap.get(FileCleaningJobSchedulerImpl.MAX_AGE_KEY);
                FileManager fileManager = (FileManager)ComponentAccessor.getOSGiComponentInstanceOfType(FileManager.class);
                fileManager.clearOlderThan(maxAgeInMs);
            }
            catch (Exception e) {
                this.LOG.error("Error occurred while cleaning workflow exports.", (Throwable)e);
            }
        }
    }
}

