/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.exporter.servlet;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.workflow.sharing.exporter.servlet.ErrorRenderer;
import com.atlassian.jira.plugins.workflow.sharing.file.FileCleaningJobScheduler;
import com.atlassian.jira.plugins.workflow.sharing.file.FileManager;
import com.atlassian.jira.plugins.workflow.sharing.servlet.AbstractServlet;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class SharedWorkflowDownloadServlet
extends AbstractServlet {
    private static final String ORIGIN_PARAM = "origin";
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final FileManager fileManager;
    private final I18nResolver i18n;
    private final ErrorRenderer errorRenderer;
    private final FileCleaningJobScheduler fileCleaningJobScheduler;

    public SharedWorkflowDownloadServlet(UserManager userManager, LoginUriProvider loginUriProvider, FileManager fileManager, I18nResolver i18n, ErrorRenderer errorRenderer, FileCleaningJobScheduler fileCleaningJobScheduler, ApplicationProperties applicationProperties) {
        super(applicationProperties);
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.fileManager = fileManager;
        this.i18n = i18n;
        this.errorRenderer = errorRenderer;
        this.fileCleaningJobScheduler = fileCleaningJobScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletOutputStream sos;
        FileInputStream is;
        block9: {
            block8: {
                String username = this.userManager.getRemoteUsername(req);
                if (username == null || !this.userManager.isAdmin(username) && !this.userManager.isSystemAdmin(username)) {
                    this.redirectToLogin(req, resp);
                    return;
                }
                is = null;
                sos = null;
                try {
                    String actualFilename = req.getParameter("file");
                    String nameToDisplay = this.fileManager.getExportFileNameToDisplay(actualFilename);
                    File zipFile = this.fileManager.getExportedWorkflowFile(actualFilename);
                    if (!zipFile.exists()) {
                        long intervalInMinutes = TimeUnit.MINUTES.convert(this.fileCleaningJobScheduler.getCurrentMaxAge(), TimeUnit.MILLISECONDS);
                        String error = this.i18n.getText("wfshare.export.file.not.found", new Serializable[]{Long.valueOf(intervalInMinutes)});
                        this.renderError(req, resp, error);
                        IOUtils.closeQuietly((InputStream)is);
                        break block8;
                    }
                    is = new FileInputStream(zipFile);
                    resp.setContentType("application/zip");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + nameToDisplay + "\"");
                    sos = resp.getOutputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)sos);
                    sos.flush();
                    IOUtils.closeQuietly((InputStream)is);
                    break block9;
                }
                catch (FileNotFoundException e) {
                    String error = this.i18n.getText("wfshare.export.could.not.read.file");
                    this.renderError(req, resp, error);
                    return;
                }
            }
            IOUtils.closeQuietly((OutputStream)sos);
            return;
        }
        IOUtils.closeQuietly((OutputStream)sos);
        return;
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(sos);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void renderError(HttpServletRequest req, HttpServletResponse resp, String error) throws IOException {
        resp.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> context = new HashMap<String, Object>();
        String originalUrl = req.getParameter(ORIGIN_PARAM);
        context.put("cancelUrl", originalUrl == null ? "" : this.encodeUrl(originalUrl));
        this.errorRenderer.render(error, resp, context);
    }
}

