/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.exporter.servlet;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelper;
import com.atlassian.jira.plugins.workflow.sharing.exporter.WorkflowExportNotesProvider;
import com.atlassian.jira.plugins.workflow.sharing.exporter.component.JiraWorkflowSharingExporter;
import com.atlassian.jira.plugins.workflow.sharing.exporter.servlet.ErrorRenderer;
import com.atlassian.jira.plugins.workflow.sharing.file.CanNotCreateFileException;
import com.atlassian.jira.plugins.workflow.sharing.file.FileCleaningJobScheduler;
import com.atlassian.jira.plugins.workflow.sharing.file.FileManager;
import com.atlassian.jira.plugins.workflow.sharing.servlet.AbstractServletWizardHandler;
import com.atlassian.jira.plugins.workflow.sharing.servlet.DataNotFoundInSessionException;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ServletMapping;
import com.atlassian.jira.plugins.workflow.sharing.servlet.ValidationException;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.HelpPathResolver;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.Multimap;
import com.opensymphony.workflow.FactoryException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportWizardHandler
extends AbstractServletWizardHandler {
    private final Logger LOG = LoggerFactory.getLogger(ExportWizardHandler.class);
    public static final String WF_NAME_FIELD_NAME = "workflowName";
    public static final String WF_MODE_FIELD_NAME = "workflowMode";
    public static final String NOTES_FIELD_NAME = "notes";
    public static final String EXPORTED_FILE = "exportedFile";
    public static final String EXPORTED_FILE_NAME = "exportedFileName";
    public static final String MANUAL_NOTES = "manualNotes";
    public static final String GENERATED_NOTES = "generatedNotes";
    private final TemplateRenderer renderer;
    private final JiraWorkflowSharingExporter jiraWorkflowSharingExporter;
    private final WorkflowExtensionsHelper workflowExtensionsHelper;
    private final VelocityRequestContextFactory requestContextFactory;
    private final WorkflowExportNotesProvider workflowNotesProvider;
    private final FileManager fileManager;
    private final ErrorRenderer errorRenderer;
    private final FileCleaningJobScheduler fileCleaningJobScheduler;
    private final HelpPathResolver helpPathResolver;

    protected ExportWizardHandler(LoginUriProvider loginUriProvider, UserManager userManager, TemplateRenderer renderer, JiraWorkflowSharingExporter jiraWorkflowSharingExporter, WorkflowExtensionsHelper workflowExtensionsHelper, VelocityRequestContextFactory requestContextFactory, WorkflowExportNotesProvider workflowNotesProvider, I18nResolver i18n, FileManager fileManager, ErrorRenderer errorRenderer, FileCleaningJobScheduler fileCleaningJobScheduler, XsrfTokenValidator xsrfTokenValidator, XsrfTokenGenerator xsrfTokenGenerator, ApplicationProperties applicationProperties, HelpPathResolver helpPathResolver) {
        super(loginUriProvider, userManager, i18n, xsrfTokenValidator, xsrfTokenGenerator, applicationProperties);
        this.renderer = renderer;
        this.jiraWorkflowSharingExporter = jiraWorkflowSharingExporter;
        this.workflowExtensionsHelper = workflowExtensionsHelper;
        this.requestContextFactory = requestContextFactory;
        this.workflowNotesProvider = workflowNotesProvider;
        this.fileManager = fileManager;
        this.errorRenderer = errorRenderer;
        this.fileCleaningJobScheduler = fileCleaningJobScheduler;
        this.helpPathResolver = helpPathResolver;
    }

    private void handleRequest(HttpServletRequest request, HttpServletResponse response, AbstractServletWizardHandler.RequestHandler handler) throws IOException {
        if (this.enforceAdminLogin(request, response)) {
            return;
        }
        JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
        response.setContentType("text/html;charset=utf-8");
        super.clearSessionAttributes(request.getSession());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("requestContext", this.requestContextFactory.getJiraVelocityRequestContext());
        ServletMapping requestMapping = ServletMapping.fromPath(this.getMappingPath(request));
        context.put("cancelUrl", this.getCancelUrl(request));
        try {
            handler.handle(request, response, context, requestMapping);
        }
        catch (DataNotFoundInSessionException e) {
            response.sendRedirect(ServletMapping.START_EXPORT.getPath() + "?" + "notFoundInSession" + "=true");
        }
        catch (CanNotCreateFileException e) {
            String error = this.i18n.getText("wfshare.export.could.not.write.file");
            this.errorRenderer.render(error, response, context);
        }
        catch (Exception e) {
            this.LOG.debug("Unable to export workflow", (Throwable)e);
            String message = e.getMessage();
            if (StringUtils.isBlank((String)message)) {
                message = this.i18n.getText("wfshare.export.error.generic");
            }
            this.errorRenderer.render(message, response, context);
        }
    }

    private String getCancelUrl(HttpServletRequest request) {
        String wfName = (String)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_EXPORT_WFNAME.name());
        String wfMode = (String)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_EXPORT_WFMODE.name());
        if (wfName == null) {
            wfName = request.getParameter(WF_NAME_FIELD_NAME);
        }
        if (wfMode == null) {
            wfMode = request.getParameter(WF_MODE_FIELD_NAME);
        }
        if (wfName == null || wfMode == null) {
            return request.getContextPath() + "/secure/admin/workflows/ListWorkflows.jspa";
        }
        return request.getContextPath() + "/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=" + wfMode + "&workflowName=" + JiraUrlCodec.encode((String)wfName);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handleRequest(request, response, new AbstractServletWizardHandler.RequestHandler(){

            @Override
            public void handle(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context, ServletMapping requestMapping) throws DataNotFoundInSessionException, IOException, FactoryException, ValidationException {
                switch (requestMapping) {
                    case START_EXPORT: {
                        ExportWizardHandler.this.showStartExport(request, response, context);
                        break;
                    }
                    case EXPORT_ADD_NOTES: {
                        ExportWizardHandler.this.showAddNotes(request, response, context);
                        break;
                    }
                    case EXPORT_WORKFLOW_SUCCESS: {
                        ExportWizardHandler.this.showSuccess(request, response, context);
                        break;
                    }
                    case NOT_MAPPED: {
                        ExportWizardHandler.this.showStartExport(request, response, context);
                    }
                }
            }
        });
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handleRequest(request, response, new AbstractServletWizardHandler.RequestHandler(){

            @Override
            public void handle(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context, ServletMapping requestMapping) throws DataNotFoundInSessionException, IOException, FactoryException, ValidationException, CanNotCreateFileException, ServletException {
                switch (requestMapping) {
                    case START_EXPORT: {
                        ExportWizardHandler.this.doStartExport(response);
                        break;
                    }
                    case EXPORT_ADD_NOTES: {
                        ExportWizardHandler.this.doAddNotes(request, response);
                    }
                }
            }
        });
    }

    private void showStartExport(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws ValidationException, IOException {
        String dataNotFoundInSession = request.getParameter("notFoundInSession");
        if (StringUtils.isNotEmpty((String)dataNotFoundInSession)) {
            context.put("errorMessage", this.i18n.getText("wfshare.exception.export.data.not.found.in.session"));
        } else {
            String wfName = (String)this.getSessionAttributeOrNull(request, SessionVar.WFSHARE_EXPORT_WFNAME.name());
            Pair<String, String> nameAndMode = this.extractWorkflowNameAndMode(request);
            if (null != nameAndMode) {
                wfName = (String)nameAndMode.first();
                String wfMode = (String)nameAndMode.second();
                request.getSession().setAttribute(SessionVar.WFSHARE_EXPORT_WFNAME.name(), (Object)wfName);
                request.getSession().setAttribute(SessionVar.WFSHARE_EXPORT_WFMODE.name(), (Object)wfMode);
            }
            if (StringUtils.isBlank((String)wfName) && request.getParameter("notFoundInSession") == null) {
                throw new ValidationException(this.i18n.getText("wfshare.exception.no.workflow.name.param"));
            }
            context.put(WF_NAME_FIELD_NAME, wfName);
            context.put("helpPath", this.helpPathResolver.getHelpPath("workflow_sharing"));
        }
        this.setNavigationPaths(context, ServletMapping.START_EXPORT);
        this.renderer.render(ServletMapping.START_EXPORT.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private void doStartExport(HttpServletResponse response) throws IOException {
        response.sendRedirect(ServletMapping.EXPORT_ADD_NOTES.getPath());
    }

    private void showAddNotes(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws IOException, DataNotFoundInSessionException {
        Pair<String, String> nameAndMode = this.extractWorkflowNameAndModeFromSession(request);
        JiraWorkflow workflow = this.workflowExtensionsHelper.getWorkflowForNameAndMode((String)nameAndMode.first(), (String)nameAndMode.second());
        String notes = this.workflowNotesProvider.createNotes(workflow);
        context.put(NOTES_FIELD_NAME, notes);
        String notesHash = StringUtils.isEmpty((String)notes) ? null : DigestUtils.md5Hex((String)notes);
        request.getSession().setAttribute(SessionVar.GENERATED_NOTES_HASH.name(), (Object)notesHash);
        this.addXsrfToken(context, request);
        this.setNavigationPaths(context, ServletMapping.EXPORT_ADD_NOTES);
        this.renderer.render(ServletMapping.EXPORT_ADD_NOTES.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private void doAddNotes(HttpServletRequest request, HttpServletResponse response) throws DataNotFoundInSessionException, IOException, ValidationException, CanNotCreateFileException, ServletException {
        if (this.checkXsrf(request, response)) {
            return;
        }
        String notes = request.getParameter(NOTES_FIELD_NAME);
        String wfName = (String)this.getSessionAttribute(request, SessionVar.WFSHARE_EXPORT_WFNAME.name());
        String wfMode = (String)this.getSessionAttribute(request, SessionVar.WFSHARE_EXPORT_WFMODE.name());
        JiraWorkflowSharingExporter.ExportResult result = "draft".equalsIgnoreCase(wfMode) ? this.jiraWorkflowSharingExporter.exportDraftWorflow(wfName, notes) : this.jiraWorkflowSharingExporter.exportActiveWorkflow(wfName, notes);
        if (null == result) {
            throw new ValidationException(this.i18n.getText("wfshare.exception.null.workflow.zip", new Serializable[]{wfName}));
        }
        this.fileManager.addExportedFileNameMapping(result.getName(), result.getWorkflowNameAsFileName());
        Pair<Boolean, Boolean> noteInfo = this.calculateNoteInfo(request, notes);
        this.clearSessionAttributes(request.getSession());
        String successUrl = ServletMapping.EXPORT_WORKFLOW_SUCCESS.getPath() + "?" + WF_NAME_FIELD_NAME + "=" + JiraUrlCodec.encode((String)wfName) + "&" + WF_MODE_FIELD_NAME + "=" + wfMode + "&" + EXPORTED_FILE + "=" + result.getName() + "&" + EXPORTED_FILE_NAME + "=" + JiraUrlCodec.encode((String)result.getWorkflowNameAsFileName()) + "&" + MANUAL_NOTES + "=" + noteInfo.first() + "&" + GENERATED_NOTES + "=" + noteInfo.second();
        response.sendRedirect(successUrl);
    }

    private void showSuccess(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws DataNotFoundInSessionException, ValidationException, IOException {
        String exportedFile = request.getParameter(EXPORTED_FILE);
        long intervalInMinutes = TimeUnit.MINUTES.convert(this.fileCleaningJobScheduler.getCurrentMaxAge(), TimeUnit.MILLISECONDS);
        File zipFile = this.fileManager.getExportedWorkflowFile(exportedFile);
        if (!zipFile.exists()) {
            String error = this.i18n.getText("wfshare.export.file.not.found", new Serializable[]{Long.valueOf(intervalInMinutes)});
            this.errorRenderer.render(error, response, context);
            return;
        }
        String wfName = request.getParameter(WF_NAME_FIELD_NAME);
        String wfMode = request.getParameter(WF_MODE_FIELD_NAME);
        String exportedFileName = request.getParameter(EXPORTED_FILE_NAME);
        boolean manualNotes = Boolean.valueOf(request.getParameter(MANUAL_NOTES));
        boolean generatedNotes = Boolean.valueOf(request.getParameter(GENERATED_NOTES));
        context.put(WF_NAME_FIELD_NAME, exportedFileName);
        context.put("exportedZip", exportedFile);
        context.put(MANUAL_NOTES, manualNotes);
        context.put(GENERATED_NOTES, generatedNotes);
        context.put("nrOfPlugins", this.getNrOfPlugins(wfName, wfMode));
        context.put("maxAgeInMinutes", intervalInMinutes);
        String cancelUrl = (String)context.get("cancelUrl");
        context.put("cancelUrlEncoded", this.encodeUrl(cancelUrl));
        context.put("helpPath", this.helpPathResolver.getHelpPath("workflow_sharing"));
        this.renderer.render(ServletMapping.EXPORT_WORKFLOW_SUCCESS.getResultTemplate(), context, (Writer)response.getWriter());
    }

    private <T> T getSessionAttribute(HttpServletRequest request, String name) throws DataNotFoundInSessionException {
        Object value = this.getSessionAttributeOrNull(request, name);
        if (value != null) {
            return value;
        }
        throw new DataNotFoundInSessionException();
    }

    private Pair<Boolean, Boolean> calculateNoteInfo(HttpServletRequest request, String notes) {
        boolean manualNotes;
        boolean generatedNotes;
        String generatedNotesHash = (String)this.getSessionAttributeOrNull(request, SessionVar.GENERATED_NOTES_HASH.name());
        if (generatedNotesHash != null) {
            String notesHash;
            generatedNotes = true;
            manualNotes = StringUtils.isEmpty((String)notes) ? true : !generatedNotesHash.equals(notesHash = DigestUtils.md5Hex((String)(notes = notes.replace("\r", ""))));
        } else {
            generatedNotes = false;
            manualNotes = StringUtils.isNotEmpty((String)notes);
        }
        return Pair.strictPairOf((Object)manualNotes, (Object)generatedNotes);
    }

    private int getNrOfPlugins(String wfName, String wfMode) throws ValidationException {
        JiraWorkflow workflow = this.getWorkflow(wfName, wfMode);
        Multimap<Plugin, String> requiredPlugins = this.workflowExtensionsHelper.getRequiredPlugins(workflow);
        return requiredPlugins.size();
    }

    private JiraWorkflow getWorkflow(String wfName, String wfMode) throws ValidationException {
        JiraWorkflow workflow = this.workflowExtensionsHelper.getWorkflowForNameAndMode(wfName, wfMode);
        if (null == workflow) {
            throw new ValidationException(this.i18n.getText("wfshare.exception.workflow.not.found", new Serializable[]{wfName}));
        }
        return workflow;
    }

    private Pair<String, String> extractWorkflowNameAndModeFromSession(HttpServletRequest request) throws DataNotFoundInSessionException {
        String wfName = (String)this.getSessionAttribute(request, SessionVar.WFSHARE_EXPORT_WFNAME.name());
        String wfMode = (String)this.getSessionAttribute(request, SessionVar.WFSHARE_EXPORT_WFMODE.name());
        return Pair.strictPairOf((Object)wfName, (Object)wfMode);
    }

    private Pair<String, String> extractWorkflowNameAndMode(HttpServletRequest request) {
        String wfName = request.getParameter(WF_NAME_FIELD_NAME);
        String wfMode = request.getParameter(WF_MODE_FIELD_NAME);
        if (StringUtils.isBlank((String)wfName)) {
            return null;
        }
        if (StringUtils.isBlank((String)wfMode)) {
            wfMode = "live";
        }
        return Pair.strictPairOf((Object)wfName, (Object)wfMode);
    }

    private void setNavigationPaths(Map<String, Object> context, ServletMapping servletMapping) {
        String nextPath = "/plugins/servlet/wfshare-export/" + servletMapping.getPath();
        String backPath = "";
        if (null != servletMapping.previous()) {
            backPath = "/plugins/servlet/wfshare-export/" + servletMapping.previous().getPath();
        }
        context.put("nextUrl", this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl() + nextPath);
        context.put("backUrl", this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl() + backPath);
    }

    @Override
    protected void clearSessionAttributes(HttpSession session) {
        super.clearSessionAttributes(session);
        for (SessionVar sessionVar : SessionVar.values()) {
            session.removeAttribute(sessionVar.name());
        }
    }

    private static enum SessionVar {
        WFSHARE_EXPORT_WFNAME,
        WFSHARE_EXPORT_WFMODE,
        WFSHARE_EXPORT_NOTES,
        GENERATED_NOTES_HASH;

    }
}

