/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.exporter.component;

import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflow.sharing.exporter.component.WorkflowStatusExportHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.StatusInfo;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowStatusExportHelperImpl
implements WorkflowStatusExportHelper {
    private static final List<String> SYSTEM_STATUSES = Lists.newArrayList((Object[])new String[]{"1", "3", "4", "5", "6"});

    @Override
    public String getStatusesJson(List<Status> statuses) throws IOException {
        ArrayList statusInfoList = Lists.newArrayList();
        for (Status status : statuses) {
            if (SYSTEM_STATUSES.contains(status.getId())) continue;
            Long statusCategoryId = null == status.getStatusCategory() ? null : status.getStatusCategory().getId();
            statusInfoList.add(new StatusInfo(status.getId(), status.getName(), status.getDescription(), statusCategoryId));
        }
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        mapper.writeValue((Writer)sw, (Object)statusInfoList);
        return sw.toString();
    }
}

