/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.exporter.component;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowCustomFieldsHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowLayoutKeyFinder;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowScreensHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowSharingFiles;
import com.atlassian.jira.plugins.workflow.sharing.exporter.component.JiraWorkflowSharingExporter;
import com.atlassian.jira.plugins.workflow.sharing.exporter.component.WorkflowStatusExportHelper;
import com.atlassian.jira.plugins.workflow.sharing.file.CanNotCreateFileException;
import com.atlassian.jira.plugins.workflow.sharing.file.FileManager;
import com.atlassian.jira.plugins.workflow.sharing.util.IOSupport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.message.I18nResolver;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.sysbliss.jira.plugins.workflow.util.WorkflowDesignerPropertySet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class JiraWorkflowSharingExporterImpl
implements JiraWorkflowSharingExporter {
    public static final String CLEAN_FILENAME_PATTERN = "[:\\\\/*?|<> _]";
    private final WorkflowService workflowService;
    private final WorkflowDesignerPropertySet workflowDesignerPropertySet;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowExtensionsHelper workflowExtensionsHelper;
    private final WorkflowScreensHelper workflowScreensHelper;
    private final WorkflowCustomFieldsHelper workflowCustomFieldsHelper;
    private final I18nResolver i18n;
    private final WorkflowLayoutKeyFinder workflowLayoutKeyFinder;
    private final FileManager fileManager;
    private final WorkflowStatusExportHelper workflowStatusHelper;

    @Autowired
    public JiraWorkflowSharingExporterImpl(WorkflowDesignerPropertySet workflowDesignerPropertySet, WorkflowService workflowService, WorkflowExtensionsHelper workflowExtensionsHelper, JiraAuthenticationContext jiraAuthenticationContext, WorkflowScreensHelper workflowScreensHelper, WorkflowCustomFieldsHelper workflowCustomFieldsHelper, I18nResolver i18n, WorkflowLayoutKeyFinder workflowLayoutKeyFinder, FileManager fileManager, WorkflowStatusExportHelper workflowStatusHelper) {
        this.workflowDesignerPropertySet = workflowDesignerPropertySet;
        this.workflowService = workflowService;
        this.workflowExtensionsHelper = workflowExtensionsHelper;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowScreensHelper = workflowScreensHelper;
        this.workflowCustomFieldsHelper = workflowCustomFieldsHelper;
        this.i18n = i18n;
        this.workflowLayoutKeyFinder = workflowLayoutKeyFinder;
        this.fileManager = fileManager;
        this.workflowStatusHelper = workflowStatusHelper;
    }

    @Override
    public JiraWorkflowSharingExporter.ExportResult exportActiveWorkflow(String name, String notes) throws CanNotCreateFileException {
        JiraWorkflowSharingExporter.ExportResult result = null;
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        JiraWorkflow workflow = this.workflowService.getWorkflow((JiraServiceContext)jiraServiceContext, name);
        if (null != workflow) {
            try {
                String layoutKey = this.workflowLayoutKeyFinder.getActiveLayoutKey(workflow.getName());
                String layoutV2Key = this.workflowLayoutKeyFinder.getActiveLayoutV2Key(workflow.getName());
                String annotationKey = "jira.jwd.annotation:".concat(workflow.getName());
                result = this.exportWorkflow(workflow, layoutKey, layoutV2Key, annotationKey, notes);
            }
            catch (CanNotCreateFileException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public JiraWorkflowSharingExporter.ExportResult exportDraftWorflow(String name, String notes) throws CanNotCreateFileException {
        JiraWorkflowSharingExporter.ExportResult result = null;
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        JiraWorkflow workflow = this.workflowService.getDraftWorkflow((JiraServiceContext)jiraServiceContext, name);
        if (null != workflow) {
            try {
                String layoutKey = this.workflowLayoutKeyFinder.getDraftLayoutKey(workflow.getName());
                String layoutV2Key = this.workflowLayoutKeyFinder.getDraftLayoutV2Key(workflow.getName());
                String annotationKey = "jira.jwd.draft.annotation:".concat(workflow.getName());
                result = this.exportWorkflow(workflow, layoutKey, layoutV2Key, annotationKey, notes);
            }
            catch (CanNotCreateFileException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JiraWorkflowSharingExporter.ExportResult exportWorkflow(JiraWorkflow workflow, String layoutKey, String layoutV2Key, String annotationKey, String notes) throws Exception {
        workflow = this.workflowExtensionsHelper.copyAndRemoveIllegalComponents(workflow);
        String workflowXml = WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)workflow.getDescriptor());
        String layoutJson = this.workflowDesignerPropertySet.getProperty(layoutKey);
        String layoutV2Json = this.workflowDesignerPropertySet.getProperty(layoutV2Key);
        String annotationJson = this.workflowDesignerPropertySet.getProperty(annotationKey);
        String statusesJson = this.workflowStatusHelper.getStatusesJson(workflow.getLinkedStatusObjects());
        String customFieldsJson = this.workflowCustomFieldsHelper.getCustomFieldsJson(this.workflowScreensHelper.getCustomFieldIdsForWorkflowScreens(workflow));
        String screensJson = this.workflowScreensHelper.getScreensJson(workflow);
        ZipOutputStream zipOutputStream = null;
        File zipFile = null;
        try {
            zipFile = this.fileManager.createExportedWorkflowFile();
            zipOutputStream = new ZipOutputStream(new FileOutputStream(zipFile));
            if (!StringUtils.isNotBlank((String)workflowXml)) {
                throw new IOException(this.i18n.getText("wfshare.exception.workflow.xml.is.blank"));
            }
            this.addStringToZip(WorkflowSharingFiles.WORKFLOW.getPath(), workflowXml, zipOutputStream);
            if (StringUtils.isNotBlank((String)layoutJson)) {
                this.addStringToZip(WorkflowSharingFiles.LAYOUT.getPath(), layoutJson, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)layoutV2Json)) {
                this.addStringToZip(WorkflowSharingFiles.LAYOUT_V2.getPath(), layoutV2Json, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)annotationJson)) {
                this.addStringToZip(WorkflowSharingFiles.ANNOTATION.getPath(), annotationJson, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)customFieldsJson) && !customFieldsJson.equals("[]")) {
                this.addStringToZip(WorkflowSharingFiles.CUSTOM_FIELDS.getPath(), customFieldsJson, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)statusesJson) && !statusesJson.equals("[]")) {
                this.addStringToZip(WorkflowSharingFiles.STATUSES.getPath(), statusesJson, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)screensJson) && !screensJson.equals("[]")) {
                this.addStringToZip(WorkflowSharingFiles.SCREENS.getPath(), screensJson, zipOutputStream);
            }
            if (StringUtils.isNotBlank((String)notes)) {
                this.addStringToZip(WorkflowSharingFiles.NOTES.getPath(), notes, zipOutputStream);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)zipOutputStream);
        String workflowNameAsFileName = workflow.getName().replaceAll(CLEAN_FILENAME_PATTERN, "-");
        if (workflow.isDraftWorkflow()) {
            workflowNameAsFileName = workflowNameAsFileName.concat("-draft");
        }
        workflowNameAsFileName = workflowNameAsFileName.concat(".jwb");
        return new JiraWorkflowSharingExporter.ExportResult(zipFile, workflowNameAsFileName);
    }

    protected void addStringToZip(String filename, String content, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(filename));
        IOSupport.writeString(content, zipOutputStream);
        zipOutputStream.closeEntry();
    }
}

