/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing.exporter;

import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.plugins.workflow.sharing.ModuleDescriptorLocator;
import com.atlassian.jira.plugins.workflow.sharing.RemovedItems;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelper;
import com.atlassian.jira.plugins.workflow.sharing.exporter.WorkflowExportNotesProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowExportNotesProviderImpl
implements WorkflowExportNotesProvider {
    private final WorkflowExtensionsHelper workflowExtensionsHelper;
    private final ModuleDescriptorLocator moduleDescriptorLocator;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public WorkflowExportNotesProviderImpl(WorkflowExtensionsHelper workflowExtensionsHelper, ModuleDescriptorLocator moduleDescriptorLocator, JiraAuthenticationContext jiraAuthenticationContext) {
        this.workflowExtensionsHelper = workflowExtensionsHelper;
        this.moduleDescriptorLocator = moduleDescriptorLocator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public String createNotes(JiraWorkflow workflow) {
        RemovedItems removedItems = this.workflowExtensionsHelper.getRemovedItems(workflow, true);
        if (removedItems.isEmpty()) {
            return "";
        }
        NotesData notesData = new NotesData();
        this.collectData(removedItems, notesData);
        return this.generateNotes(notesData);
    }

    private void collectData(RemovedItems removedItems, NotesData notesData) {
        for (RemovedItems.ActionRemovedItems actionRemovedItems : removedItems.getActionRemovedItems()) {
            if (actionRemovedItems.isEmpty()) continue;
            ActionDescriptor action = actionRemovedItems.getAction();
            NotesData.ActionData actionData = new NotesData.ActionData(action.getName());
            Collection<String> allPluginNames = notesData.getAllPluginNames();
            this.collectCategoryData(actionRemovedItems.getConditions(), actionData.getPluginConditions(), actionData.getSystemConditions(), "workflow-condition", allPluginNames);
            this.collectCategoryData(actionRemovedItems.getValidators(), actionData.getPluginValidators(), actionData.getSystemValidators(), "workflow-validator", allPluginNames);
            this.collectCategoryData(actionRemovedItems.getFunctions(), actionData.getPluginFunctions(), actionData.getSystemFunctions(), "workflow-function", allPluginNames);
            this.collectCategoryData(actionRemovedItems.getCustomFields(), actionData.getPluginCustomFields(), null, null, allPluginNames);
            actionData.setReplacedEventId(actionRemovedItems.isReplacedEventId());
            notesData.add(actionData);
        }
    }

    private String generateNotes(NotesData notesData) {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        if (!notesData.isEmpty()) {
            writer.println(this.getText("wfshare.export.notes.removed.message", new Object[0]));
            this.printList(notesData.getAllPluginNames(), writer);
            for (NotesData.ActionData actionData : notesData.getActions()) {
                if (actionData.isEmpty()) continue;
                String actionName = actionData.getTransitionName();
                this.printHeading(writer, "wfshare.export.notes.transition", actionName);
                this.writeCategory(actionData.getPluginConditions(), "wfshare.export.notes.plugin.conditions", writer);
                this.writeCategory(actionData.getSystemConditions(), "wfshare.export.notes.system.conditions", writer);
                this.writeCategory(actionData.getPluginValidators(), "wfshare.export.notes.plugin.validators", writer);
                this.writeCategory(actionData.getSystemValidators(), "wfshare.export.notes.system.validators", writer);
                this.writeCategory(actionData.getPluginFunctions(), "wfshare.export.notes.plugin.functions", writer);
                this.writeCategory(actionData.getSystemFunctions(), "wfshare.export.notes.system.functions", writer);
                if (actionData.isReplacedEventId()) {
                    writer.println();
                    writer.println(this.getText("wfshare.export.notes.custom.event.replaced", new Object[0]));
                }
                this.writeCategory(actionData.getPluginCustomFields(), "wfshare.export.notes.plugin.custom.fields", writer);
            }
        }
        return sw.toString();
    }

    private void collectCategoryData(Collection<String> classNames, Collection<String> pluginNotes, Collection<String> systemNotes, String systemPluginType, Collection<String> allPluginNames) {
        if (!classNames.isEmpty()) {
            Collection<ModuleDescriptor> descriptors;
            HashSet<String> systemClasses = new HashSet<String>();
            for (String className : classNames) {
                Collection<ModuleDescriptor> descriptors2 = this.moduleDescriptorLocator.getEnabledModuleDescriptorsByModuleClassname(className);
                if (descriptors2 != null && !descriptors2.isEmpty()) {
                    ModuleDescriptor descriptor = descriptors2.iterator().next();
                    String pluginName = descriptor.getPlugin().getName();
                    String note = descriptor.getName() + " (" + pluginName + ")";
                    pluginNotes.add(note);
                    allPluginNames.add(pluginName);
                    continue;
                }
                if (systemPluginType == null) continue;
                systemClasses.add(className);
            }
            if (!systemClasses.isEmpty() && (descriptors = this.moduleDescriptorLocator.getEnabledModuleDescriptorsByModuleType(systemPluginType)) != null && !descriptors.isEmpty()) {
                block1: for (String systemClass : systemClasses) {
                    for (ModuleDescriptor descriptor : descriptors) {
                        AbstractWorkflowModuleDescriptor workflowModuleDescriptor;
                        if (!(descriptor instanceof AbstractWorkflowModuleDescriptor) || !(workflowModuleDescriptor = (AbstractWorkflowModuleDescriptor)descriptor).getImplementationClass().getName().equals(systemClass)) continue;
                        String note = descriptor.getName();
                        systemNotes.add(note);
                        continue block1;
                    }
                }
            }
        }
    }

    private void writeCategory(Collection<String> notes, String heading, PrintWriter writer) {
        if (!notes.isEmpty()) {
            this.printHeading(writer, heading, new String[0]);
            this.printList(notes, writer);
        }
    }

    private void printList(Collection<String> notes, PrintWriter writer) {
        for (String note : notes) {
            writer.println(" - " + note);
        }
    }

    private void printHeading(PrintWriter writer, String message, String ... parameters) {
        writer.println();
        writer.println(this.getText(message, parameters));
    }

    private String getText(String key, Object ... parameters) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, (Object)parameters);
    }

    private static class NotesData {
        private final Collection<ActionData> actions = Lists.newArrayList();
        private final Collection<String> allPluginNames = Sets.newTreeSet();

        private NotesData() {
        }

        void add(ActionData actionData) {
            this.actions.add(actionData);
        }

        Collection<ActionData> getActions() {
            return this.actions;
        }

        public Collection<String> getAllPluginNames() {
            return this.allPluginNames;
        }

        public boolean isEmpty() {
            for (ActionData actionData : this.actions) {
                if (actionData.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private static class ActionData {
            private final String transitionName;
            private final Collection<String> pluginConditions = Sets.newTreeSet();
            private final Collection<String> pluginValidators = Sets.newTreeSet();
            private final Collection<String> pluginFunctions = Sets.newTreeSet();
            private final Collection<String> pluginCustomFields = Sets.newTreeSet();
            private final Collection<String> systemConditions = Sets.newTreeSet();
            private final Collection<String> systemValidators = Sets.newTreeSet();
            private final Collection<String> systemFunctions = Sets.newTreeSet();
            private boolean replacedEventId;

            private ActionData(String transitionName) {
                this.transitionName = transitionName;
            }

            public String getTransitionName() {
                return this.transitionName;
            }

            public Collection<String> getPluginConditions() {
                return this.pluginConditions;
            }

            public Collection<String> getPluginValidators() {
                return this.pluginValidators;
            }

            public Collection<String> getPluginFunctions() {
                return this.pluginFunctions;
            }

            public Collection<String> getPluginCustomFields() {
                return this.pluginCustomFields;
            }

            public Collection<String> getSystemConditions() {
                return this.systemConditions;
            }

            public Collection<String> getSystemValidators() {
                return this.systemValidators;
            }

            public Collection<String> getSystemFunctions() {
                return this.systemFunctions;
            }

            public void setReplacedEventId(boolean replacedEventId) {
                this.replacedEventId = replacedEventId;
            }

            public boolean isReplacedEventId() {
                return this.replacedEventId;
            }

            public boolean isEmpty() {
                return this.pluginConditions.isEmpty() && this.pluginValidators.isEmpty() && this.pluginFunctions.isEmpty() && this.pluginCustomFields.isEmpty() && this.systemConditions.isEmpty() && this.systemValidators.isEmpty() && this.systemFunctions.isEmpty() && !this.replacedEventId;
            }
        }
    }
}

