/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowCustomFieldsHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowScreensHelper;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenItemInfo;
import com.atlassian.jira.plugins.workflow.sharing.model.ScreenTabInfo;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowScreensHelperImpl
implements WorkflowScreensHelper {
    private final FieldScreenManager fieldScreenManager;
    private final WorkflowCustomFieldsHelper customFieldsHelper;

    @Autowired
    public WorkflowScreensHelperImpl(FieldScreenManager fieldScreenManager, WorkflowCustomFieldsHelper customFieldsHelper) {
        this.fieldScreenManager = fieldScreenManager;
        this.customFieldsHelper = customFieldsHelper;
    }

    @Override
    public Set<String> getClassnamesForScreen(String screenId) {
        HashSet<String> classNames = new HashSet<String>();
        if (StringUtils.isNumeric((String)screenId)) {
            FieldScreen screen = this.fieldScreenManager.getFieldScreen(Long.valueOf(Long.parseLong(screenId)));
            for (FieldScreenTab tab : screen.getTabs()) {
                List items = tab.getFieldScreenLayoutItems();
                for (FieldScreenLayoutItem item : items) {
                    String cfClassname = this.customFieldsHelper.getCustomFieldTypeClassname(item.getFieldId());
                    if (!StringUtils.isNotBlank((String)cfClassname)) continue;
                    classNames.add(cfClassname);
                }
            }
        }
        return classNames;
    }

    @Override
    public Set<String> getClassnamesForScreenFromAction(ActionDescriptor action) {
        HashSet<String> classNames = new HashSet<String>();
        if ("fieldscreen".equals(action.getView()) && action.getMetaAttributes().containsKey("jira.fieldscreen.id")) {
            String screenId = (String)action.getMetaAttributes().get("jira.fieldscreen.id");
            classNames.addAll(this.getClassnamesForScreen(screenId));
        }
        return classNames;
    }

    @Override
    public Set<String> getPluginRelatedClassnamesForScreenFromAction(ActionDescriptor action) {
        String screenId;
        HashSet classNames = Sets.newHashSet();
        if ("fieldscreen".equals(action.getView()) && action.getMetaAttributes().containsKey("jira.fieldscreen.id") && StringUtils.isNumeric((String)(screenId = (String)action.getMetaAttributes().get("jira.fieldscreen.id")))) {
            FieldScreen screen = this.fieldScreenManager.getFieldScreen(Long.valueOf(Long.parseLong(screenId)));
            for (FieldScreenTab tab : screen.getTabs()) {
                List items = tab.getFieldScreenLayoutItems();
                for (FieldScreenLayoutItem item : items) {
                    String fieldId = item.getFieldId();
                    String className = this.customFieldsHelper.getPluginRelatedClassName(fieldId);
                    if (className == null) continue;
                    classNames.add(className);
                }
            }
        }
        return classNames;
    }

    @Override
    public Iterable<String> getCustomFieldIdsForWorkflowScreens(JiraWorkflow workflow) {
        HashSet<String> ids = new HashSet<String>();
        Collection allActions = workflow.getAllActions();
        for (ActionDescriptor action : allActions) {
            String screenId;
            if (!"fieldscreen".equals(action.getView()) || !action.getMetaAttributes().containsKey("jira.fieldscreen.id") || !StringUtils.isNumeric((String)(screenId = (String)action.getMetaAttributes().get("jira.fieldscreen.id")))) continue;
            FieldScreen screen = this.fieldScreenManager.getFieldScreen(Long.valueOf(Long.parseLong(screenId)));
            for (FieldScreenTab tab : screen.getTabs()) {
                List items = tab.getFieldScreenLayoutItems();
                for (FieldScreenLayoutItem item : items) {
                    ids.add(item.getFieldId());
                }
            }
        }
        return ids;
    }

    @Override
    public void updateWorkflowScreenIds(ConfigurableJiraWorkflow jiraWorkflow, Map<Long, Long> oldToNewIdMapping) {
        Collection allActions = jiraWorkflow.getAllActions();
        for (ActionDescriptor action : allActions) {
            Long oldScreenId;
            String screenId;
            if (!"fieldscreen".equals(action.getView()) || !action.getMetaAttributes().containsKey("jira.fieldscreen.id") || !StringUtils.isNumeric((String)(screenId = (String)action.getMetaAttributes().get("jira.fieldscreen.id"))) || !oldToNewIdMapping.containsKey(oldScreenId = Long.valueOf(Long.parseLong(screenId)))) continue;
            action.getMetaAttributes().put("jira.fieldscreen.id", Long.toString(oldToNewIdMapping.get(oldScreenId)));
        }
    }

    @Override
    public String getScreensJson(JiraWorkflow workflow) throws IOException {
        ArrayList<ScreenInfo> screenInfoList = new ArrayList<ScreenInfo>();
        Collection allActions = workflow.getAllActions();
        for (ActionDescriptor action : allActions) {
            String screenId;
            if (!"fieldscreen".equals(action.getView()) || !action.getMetaAttributes().containsKey("jira.fieldscreen.id") || !StringUtils.isNumeric((String)(screenId = (String)action.getMetaAttributes().get("jira.fieldscreen.id"))) || !Collections2.filter(screenInfoList, (Predicate)new Predicate<ScreenInfo>(){

                public boolean apply(ScreenInfo input) {
                    return input.getOriginalId().toString().equals(screenId);
                }
            }).isEmpty()) continue;
            FieldScreen screen = this.fieldScreenManager.getFieldScreen(Long.valueOf(Long.parseLong(screenId)));
            ArrayList<ScreenTabInfo> tabs = new ArrayList<ScreenTabInfo>(screen.getTabs().size());
            for (FieldScreenTab tab : screen.getTabs()) {
                ArrayList items = new ArrayList(tab.getFieldScreenLayoutItems());
                Collections.sort(items, new PositionComparator());
                ArrayList<ScreenItemInfo> tabItems = new ArrayList<ScreenItemInfo>(items.size());
                int position = 0;
                for (FieldScreenLayoutItem item : items) {
                    String fieldId = item.getFieldId();
                    if (this.customFieldsHelper.isFromPlugin(fieldId)) continue;
                    tabItems.add(new ScreenItemInfo(item.getId(), fieldId, position));
                    ++position;
                }
                tabs.add(new ScreenTabInfo(tab.getId(), tab.getName(), tab.getPosition(), tabItems));
            }
            screenInfoList.add(new ScreenInfo(screen.getId(), screen.getName(), screen.getDescription(), tabs));
        }
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        mapper.writeValue((Writer)sw, screenInfoList);
        return sw.toString();
    }

    private static class PositionComparator
    implements Comparator<FieldScreenLayoutItem> {
        private PositionComparator() {
        }

        @Override
        public int compare(FieldScreenLayoutItem first, FieldScreenLayoutItem second) {
            return new CompareToBuilder().append(first.getPosition(), second.getPosition()).toComparison();
        }
    }
}

