/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import org.apache.commons.codec.digest.DigestUtils;

public abstract class WorkflowLayoutPropertyKeyBuilder {
    private String workflowName;
    private WorkflowState workflowState;
    private boolean version2;

    protected WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    protected String getWorkflowName() {
        return this.workflowName;
    }

    public static WorkflowLayoutPropertyKeyBuilder newBuilder() {
        return new MD5();
    }

    public WorkflowLayoutPropertyKeyBuilder setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
        return this;
    }

    public WorkflowLayoutPropertyKeyBuilder setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
        return this;
    }

    public WorkflowLayoutPropertyKeyBuilder setVersion2(boolean version2) {
        this.version2 = version2;
        return this;
    }

    public boolean isVersion2() {
        return this.version2;
    }

    public abstract String build();

    public static enum WorkflowState {
        LIVE{

            @Override
            String keyPrefix() {
                return "jira.workflow.layout";
            }
        }
        ,
        DRAFT{

            @Override
            String keyPrefix() {
                return "jira.workflow.draft.layout";
            }
        };


        abstract String keyPrefix();
    }

    private static class MD5
    extends WorkflowLayoutPropertyKeyBuilder {
        private MD5() {
        }

        @Override
        public String build() {
            StringBuilder prefix = new StringBuilder(this.getWorkflowState().keyPrefix());
            if (this.isVersion2()) {
                prefix.append(".v5");
            }
            return prefix.append(":").append(DigestUtils.md5Hex((String)this.getWorkflowName())).toString();
        }
    }
}

