/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.plugins.workflow.sharing.ModuleDescriptorLocator;
import com.atlassian.jira.plugins.workflow.sharing.RemovedItems;
import com.atlassian.jira.plugins.workflow.sharing.WhitelistChecker;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowExtensionsHelper;
import com.atlassian.jira.plugins.workflow.sharing.WorkflowScreensHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.jira.workflow.condition.AllowOnlyAssignee;
import com.atlassian.jira.workflow.condition.AllowOnlyReporter;
import com.atlassian.jira.workflow.condition.PermissionCondition;
import com.atlassian.jira.workflow.function.event.FireIssueEventFunction;
import com.atlassian.jira.workflow.function.issue.AssignToCurrentUserFunction;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowExtensionsHelperImpl
implements WorkflowExtensionsHelper {
    private static final String[] CLASSES_WITH_USERNAME_ARGS = new String[]{AllowOnlyAssignee.class.getName(), AllowOnlyReporter.class.getName(), PermissionCondition.class.getName(), AssignToCurrentUserFunction.class.getName()};
    private final ModuleDescriptorLocator moduleDescriptorLocator;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowService workflowService;
    private final WorkflowScreensHelper workflowScreensHelper;
    private final WorkflowManager workflowManager;
    private final WhitelistChecker whitelistChecker;

    @Autowired
    public WorkflowExtensionsHelperImpl(ModuleDescriptorLocator moduleDescriptorLocator, JiraAuthenticationContext jiraAuthenticationContext, WorkflowService workflowService, WorkflowScreensHelper workflowScreensHelper, WorkflowManager workflowManager, WhitelistChecker whitelistChecker) {
        this.moduleDescriptorLocator = moduleDescriptorLocator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.workflowService = workflowService;
        this.workflowScreensHelper = workflowScreensHelper;
        this.workflowManager = workflowManager;
        this.whitelistChecker = whitelistChecker;
    }

    @Override
    public JiraWorkflow getWorkflowForNameAndMode(String name, String mode) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser());
        JiraWorkflow workflow = "draft".equalsIgnoreCase(mode) ? this.workflowService.getDraftWorkflow((JiraServiceContext)jiraServiceContext, name) : this.workflowService.getWorkflow((JiraServiceContext)jiraServiceContext, name);
        return workflow;
    }

    @Override
    public void removeIllegalComponents(JiraWorkflow jiraWorkflow) {
        this.doRemove(jiraWorkflow, null, false);
    }

    @Override
    public JiraWorkflow copyAndRemoveIllegalComponents(JiraWorkflow workflow) {
        workflow = this.copy(workflow);
        this.removeIllegalComponents(workflow);
        return workflow;
    }

    private JiraWorkflow copy(JiraWorkflow workflow) {
        try {
            WorkflowDescriptor descriptorCopy = WorkflowUtil.convertXMLtoWorkflowDescriptor((String)WorkflowUtil.convertDescriptorToXML((WorkflowDescriptor)workflow.getDescriptor()));
            return new ConfigurableJiraWorkflow(workflow.getName(), descriptorCopy, this.workflowManager);
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RemovedItems getRemovedItems(JiraWorkflow workflow, boolean includeCustomFields) {
        RemovedItems removedItems = new RemovedItems();
        this.doRemove(workflow, removedItems, includeCustomFields);
        return removedItems;
    }

    private void doRemove(JiraWorkflow workflow, RemovedItems removedItems, boolean includeCustomFields) {
        boolean delete = removedItems == null;
        Collection allActions = workflow.getAllActions();
        for (ActionDescriptor action : allActions) {
            RemovedItems.ActionRemovedItems actionRemovedItems = new RemovedItems.ActionRemovedItems(action);
            if (removedItems != null) {
                removedItems.add(actionRemovedItems);
            }
            this.discardPostFunctions(action.getUnconditionalResult().getPostFunctions(), delete, actionRemovedItems);
            this.discardPostFunctions(action.getPostFunctions(), delete, actionRemovedItems);
            this.discardValidators(action.getUnconditionalResult().getValidators(), delete, actionRemovedItems);
            this.discardValidators(action.getValidators(), delete, actionRemovedItems);
            this.removeConditions(action, delete, actionRemovedItems);
            if (removedItems == null || !includeCustomFields) continue;
            Set<String> customFields = this.workflowScreensHelper.getPluginRelatedClassnamesForScreenFromAction(action);
            for (String customField : customFields) {
                actionRemovedItems.addCustomFieldClass(customField);
            }
        }
    }

    private void discardPostFunctions(List<FunctionDescriptor> functions, boolean delete, RemovedItems.ActionRemovedItems actionRemovedItems) {
        Iterator<FunctionDescriptor> iterator = functions.iterator();
        while (iterator.hasNext()) {
            FunctionDescriptor function = iterator.next();
            Set<Map.Entry<String, String>> args = function.getArgs().entrySet();
            PostFunctionArgumentProcessor processor = new PostFunctionArgumentProcessor(delete);
            String className = this.getNotAllowedClassName(iterator, delete, args, processor);
            if (actionRemovedItems == null) continue;
            if (className != null) {
                actionRemovedItems.addFunctionClass(className);
            }
            if (!processor.isReplacedEventId()) continue;
            actionRemovedItems.markReplacedEventId();
        }
    }

    private void discardValidators(List<ValidatorDescriptor> validators, boolean delete, RemovedItems.ActionRemovedItems actionRemovedItems) {
        Iterator<ValidatorDescriptor> iterator = validators.iterator();
        while (iterator.hasNext()) {
            ValidatorDescriptor validator = iterator.next();
            Set<Map.Entry<String, String>> args = validator.getArgs().entrySet();
            String className = this.getNotAllowedClassName(iterator, delete, args);
            if (className == null || actionRemovedItems == null) continue;
            actionRemovedItems.addValidatorClass(className);
        }
    }

    public void removeConditions(ActionDescriptor action, boolean delete, RemovedItems.ActionRemovedItems actionRemovedItems) {
        ConditionsDescriptor rootConditions;
        if (null != action.getRestriction() && null != (rootConditions = action.getRestriction().getConditionsDescriptor())) {
            Object singleChild;
            int rootConditionNumber = this.discardConditions(rootConditions, delete, actionRemovedItems);
            if (rootConditionNumber == 0) {
                action.setRestriction(null);
            } else if (rootConditionNumber == 1 && (singleChild = rootConditions.getConditions().get(0)) instanceof ConditionsDescriptor) {
                action.getRestriction().setConditionsDescriptor((ConditionsDescriptor)singleChild);
            }
        }
    }

    private int discardConditions(ConditionsDescriptor rootConditions, boolean delete, RemovedItems.ActionRemovedItems actionRemovedItems) {
        if (null == rootConditions) {
            return 0;
        }
        List nestedConditions = rootConditions.getConditions();
        ListIterator<Object> iterator = nestedConditions.listIterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof ConditionDescriptor) {
                ConditionDescriptor condition = (ConditionDescriptor)o;
                Set<Map.Entry<String, String>> args = condition.getArgs().entrySet();
                String className = this.getNotAllowedClassName(iterator, delete, args);
                if (className == null || actionRemovedItems == null) continue;
                actionRemovedItems.addConditionClass(className);
                continue;
            }
            if (!(o instanceof ConditionsDescriptor)) continue;
            ConditionsDescriptor conditionsDescriptor = (ConditionsDescriptor)o;
            this.discardOrMergeConditionGroup(conditionsDescriptor, iterator, delete, actionRemovedItems);
        }
        return nestedConditions.size();
    }

    private void discardOrMergeConditionGroup(ConditionsDescriptor conditionsDescriptor, ListIterator<Object> iterator, boolean delete, RemovedItems.ActionRemovedItems actionRemovedItems) {
        int compositeSize = this.discardConditions(conditionsDescriptor, delete, actionRemovedItems);
        if (compositeSize == 0) {
            iterator.remove();
        } else if (compositeSize == 1) {
            Object singleChild = conditionsDescriptor.getConditions().get(0);
            iterator.set(singleChild);
        }
    }

    private String getNotAllowedClassName(Iterator<?> iterator, boolean delete, Set<Map.Entry<String, String>> args) {
        WhitelistCheckingArgumentProcessor processor = new WhitelistCheckingArgumentProcessor();
        return this.getNotAllowedClassName(iterator, delete, args, processor);
    }

    private String getNotAllowedClassName(Iterator<?> iterator, boolean delete, Set<Map.Entry<String, String>> args, WhitelistCheckingArgumentProcessor processor) {
        processor.process(args);
        String notAllowedClassName = processor.getNotAllowedClassName();
        if (notAllowedClassName != null && delete) {
            iterator.remove();
        }
        return notAllowedClassName;
    }

    private void removeUsernameArg(Set<Map.Entry<String, String>> args, String className) {
        if (ArrayUtils.contains((Object[])CLASSES_WITH_USERNAME_ARGS, (Object)className)) {
            Iterator<Map.Entry<String, String>> i = args.iterator();
            while (i.hasNext()) {
                Map.Entry<String, String> entry = i.next();
                if (!"username".equals(entry.getKey())) continue;
                i.remove();
                break;
            }
        }
    }

    private boolean checkAndReplaceEventId(Set<Map.Entry<String, String>> args, boolean replace) {
        for (Map.Entry<String, String> entry : args) {
            long value;
            if (!"eventTypeId".equals(entry.getKey()) || (value = Long.parseLong(entry.getValue())) <= EventType.ISSUE_GENERICEVENT_ID) continue;
            if (replace) {
                entry.setValue(String.valueOf(EventType.ISSUE_GENERICEVENT_ID));
            }
            return true;
        }
        return false;
    }

    @Override
    public Multimap<Plugin, String> getRequiredPlugins(JiraWorkflow workflow) {
        HashMultimap pluginExtensionMap = HashMultimap.create();
        Set<String> extensionClassnames = this.getExtensionClassnames(workflow);
        for (String classname : extensionClassnames) {
            Collection<ModuleDescriptor> moduleDescriptors = this.moduleDescriptorLocator.getEnabledModuleDescriptorsByModuleClassname(classname);
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                Plugin plugin = moduleDescriptor.getPlugin();
                if (plugin.getKey().startsWith("com.atlassian.jira.plugin.system")) continue;
                pluginExtensionMap.put((Object)plugin, (Object)classname);
            }
        }
        return pluginExtensionMap;
    }

    private Set<String> getExtensionClassnames(JiraWorkflow workflow) {
        HashSet<String> uniqueClassnames = new HashSet<String>();
        Collection allActions = workflow.getAllActions();
        for (ActionDescriptor action : allActions) {
            uniqueClassnames.addAll(this.workflowScreensHelper.getClassnamesForScreenFromAction(action));
            uniqueClassnames.addAll(this.getFunctionClassnames(action));
            uniqueClassnames.addAll(this.getValidatorClassnames(action));
            if (null == action.getRestriction()) continue;
            uniqueClassnames.addAll(this.getConditionClassnames(action.getRestriction().getConditionsDescriptor()));
        }
        return uniqueClassnames;
    }

    private Set<String> getFunctionClassnames(ActionDescriptor action) {
        List functions = action.getUnconditionalResult().getPostFunctions();
        functions.addAll(action.getPostFunctions());
        HashSet<String> classNames = new HashSet<String>();
        for (FunctionDescriptor function : functions) {
            Set<Map.Entry<String, String>> args = function.getArgs().entrySet();
            classNames.addAll(this.getClassnamesFromArgs(args));
        }
        return classNames;
    }

    private Set<String> getValidatorClassnames(ActionDescriptor action) {
        List validators = action.getUnconditionalResult().getValidators();
        validators.addAll(action.getValidators());
        HashSet<String> classNames = new HashSet<String>();
        for (ValidatorDescriptor validator : validators) {
            Set<Map.Entry<String, String>> args = validator.getArgs().entrySet();
            classNames.addAll(this.getClassnamesFromArgs(args));
        }
        return classNames;
    }

    private Set<String> getConditionClassnames(ConditionsDescriptor rootConditions) {
        HashSet<String> classNames = new HashSet<String>();
        if (null == rootConditions) {
            return classNames;
        }
        List nestedConditions = rootConditions.getConditions();
        for (Object o : nestedConditions) {
            if (o instanceof ConditionDescriptor) {
                Set<Map.Entry<String, String>> args = ((ConditionDescriptor)o).getArgs().entrySet();
                classNames.addAll(this.getClassnamesFromArgs(args));
                continue;
            }
            if (!(o instanceof ConditionsDescriptor)) continue;
            classNames.addAll(this.getConditionClassnames((ConditionsDescriptor)o));
        }
        return classNames;
    }

    private Set<String> getClassnamesFromArgs(Set<Map.Entry<String, String>> args) {
        HashSet<String> classNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : args) {
            if (!entry.getKey().equals("class.name") || !StringUtils.isNotBlank((String)entry.getValue())) continue;
            classNames.add(entry.getValue());
        }
        return classNames;
    }

    private class PostFunctionArgumentProcessor
    extends WhitelistCheckingArgumentProcessor {
        private boolean replacedEventId;
        private final boolean replace;

        private PostFunctionArgumentProcessor(boolean replace) {
            this.replace = replace;
        }

        @Override
        void process(Set<Map.Entry<String, String>> args, Set<String> classNames) {
            super.process(args, classNames);
            if (this.getNotAllowedClassName() == null) {
                for (String className : classNames) {
                    if (!FireIssueEventFunction.class.getName().equals(className)) continue;
                    this.replacedEventId = WorkflowExtensionsHelperImpl.this.checkAndReplaceEventId(args, this.replace);
                }
            }
        }

        public boolean isReplacedEventId() {
            return this.replacedEventId;
        }
    }

    private class WhitelistCheckingArgumentProcessor
    extends ArgumentProcessor {
        private String notAllowedClassName;

        private WhitelistCheckingArgumentProcessor() {
        }

        @Override
        void process(Set<Map.Entry<String, String>> args, Set<String> classNames) {
            for (String className : classNames) {
                if (!WorkflowExtensionsHelperImpl.this.whitelistChecker.isAllowed(className)) {
                    this.notAllowedClassName = className;
                    return;
                }
                WorkflowExtensionsHelperImpl.this.removeUsernameArg(args, className);
            }
        }

        String getNotAllowedClassName() {
            return this.notAllowedClassName;
        }
    }

    private abstract class ArgumentProcessor {
        private ArgumentProcessor() {
        }

        void process(Set<Map.Entry<String, String>> args) {
            Set classNames = WorkflowExtensionsHelperImpl.this.getClassnamesFromArgs(args);
            this.process(args, classNames);
        }

        abstract void process(Set<Map.Entry<String, String>> var1, Set<String> var2);
    }
}

