/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflow.sharing;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParentWorkflowChecker {
    private final WorkflowManager workflowManager;

    @Autowired
    public ParentWorkflowChecker(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public boolean isParentWorkflowActive(JiraWorkflow workflow) {
        if (!workflow.isDraftWorkflow()) {
            return true;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(workflow.getName());
        return parentWorkflow != null && parentWorkflow.isActive();
    }
}

