require([
    'jira/dialog/dialog-register',
    'wiki-edit/WikiEditor',
    'wiki-edit/skate',
    'jquery',
    'underscore',
    'backbone'
], function(Dialogs, WikiEditor, skate, $, _, Backbone) {

    function createWikiTextfield(element) {
        _.extend(element, Backbone.Events);

        var el = (this instanceof Element) ? this : element;
        var create = function(elem) {
            WikiEditor.create(elem);
            WikiEditor.initBrowseLink(elem);
            elem.wikiEnabled = true;
            $(elem).trigger("wiki-editor-initialized");
        };

        if (el.wikiEnabled === false) {
            if ($(el).is(':hidden')) {
                _.defer(create, el);
            } else {
                create(el);
            }
        }
    }
    
    function triggerDetached(element) {
        element && element.trigger && element.trigger('detached', element);
    }

    function wikiEditorDefinition() {
        return {
            type: skate.type.CLASSNAME,
            attached: createWikiTextfield,
            detached: triggerDetached,
            prototype: {
                wikiEnabled: false
            }
        };
    }

    skate('wiki-textfield', wikiEditorDefinition());

    skate('wiki-enabled-textfield', wikiEditorDefinition());

    $(function() {
        if ($("#gh").length > 0) {
            Dialogs.comment.options.width = 810;
            Dialogs.assignIssue.options.width = 810;
            Dialogs.attachFile.options.width = 810;
            Dialogs.logWork.options.width = 810;
            Dialogs.logWork.options.width = 810;
        }
    });

});
