define('wiki-edit/KeyTester', function() {

    return {
        getActionType: function(keyCode) {
            if (this.isNavigation(keyCode)) {
                return "navigating";
            } else if (this.isDeleting(keyCode)) {
                return "deleting";
            } else if (this.isReturn(keyCode)) {
                return "newline";
            } else if (this.isEscape(keyCode)) {
                return "escape";
            } else if (this.isTyping(keyCode)) {
                return "typing";
            }
        },
        isNavigation: function(keyCode) {
            // 33 - 40: page up/dn and arrow keys
            // 63232 - 63235: page up/dn and arrow keys on safari
            return (keyCode >= 33 && keyCode <= 40) || (keyCode >= 63232 && keyCode <= 63235);
        },
        isDeleting: function(keyCode) {
            // 8 - backspace
            // 46 - delete
            // 127 - delete
            return (keyCode == 8 || keyCode == 46 || keyCode == 127);
        },
        isReturn: function(keyCode) {
            return (keyCode == 13);
        },
        isEscape: function(keyCode) {
            return (keyCode == 27);
        },
// not needed at this stage but left for possible later use
//        isSpacebar: function(keyCode) {
//            return keyCode == 32; // spacebar
//        },
        isTyping: function(keyCode) {
            return (keyCode > 47 && keyCode < 58)   || // numbers
                   (keyCode > 95 && keyCode < 112)  || // numpad
                   (keyCode > 64 && keyCode < 91)   || // letters
                   (keyCode > 185 && keyCode < 193) || // ;=,-./`
                   (keyCode > 218 && keyCode < 223) || // [\]'
                    keyCode == 32                   || // spacebar
                    keyCode == 13;                     // return

        }
    };

});