/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class Task003
implements PluginUpgradeTask {
    private final ActiveObjects ao;
    private final Map<String, String> eventRenameMap;

    public Task003(ActiveObjects ao) {
        this.ao = ao;
        this.eventRenameMap = this.buildVersionRenameMap();
    }

    private ImmutableMap<String, String> buildVersionRenameMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"jira:version_created", (Object)"version_created");
        builder.put((Object)"jira:version_released", (Object)"version_released");
        builder.put((Object)"jira:version_unreleased", (Object)"version_unreleased");
        builder.put((Object)"jira:version_merged", (Object)"version_merged");
        builder.put((Object)"jira:version_deleted", (Object)"version_deleted");
        builder.put((Object)"jira:version_updated", (Object)"version_updated");
        builder.put((Object)"jira:version_moved", (Object)"version_moved");
        return builder.build();
    }

    public int getBuildNumber() {
        return 3;
    }

    public String getShortDescription() {
        return "This task strips jira: prefix from version webhook ids";
    }

    public Collection<Message> doUpgrade() throws Exception {
        WebhookDao[] webhookDaos;
        for (WebhookDao webhookDao : webhookDaos = (WebhookDao[])this.ao.find(WebhookDao.class)) {
            String[] oldEventList = webhookDao.getEvents();
            String[] newEvents = this.stripJiraPrefixFromVersionEvents(oldEventList);
            webhookDao.setEvents(newEvents);
            webhookDao.save();
        }
        return Collections.emptyList();
    }

    private String[] stripJiraPrefixFromVersionEvents(String[] oldEventList) {
        HashSet<String> eventSet = new HashSet<String>();
        for (String oldEvent : oldEventList) {
            if (this.eventRenameMap.containsKey(oldEvent)) {
                eventSet.add(this.eventRenameMap.get(oldEvent));
                continue;
            }
            eventSet.add(oldEvent);
        }
        return eventSet.toArray(new String[eventSet.size()]);
    }

    public String getPluginKey() {
        return "com.atlassian.jira.plugins.webhooks.jira-webhooks-plugin";
    }
}

