/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.store;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.fugue.Option;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.plugins.webhooks.listener.JqlFilterStoreUtils;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.spi.WebHookListenerStore;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;

public class JiraWebHookListenerStore
implements WebHookListenerStore {
    private static final Logger log = Logger.getLogger((String)JiraWebHookListenerStore.class.getName());
    private final ActiveObjects ao;
    private final UserManager userManager;
    private final I18nResolver i18n;

    public JiraWebHookListenerStore(ActiveObjects ao, UserManager userManager, I18nResolver i18n) {
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18n);
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    public PersistentWebHookListener addWebHook(final PersistentWebHookListener listener, final RegistrationMethod registrationMethod) {
        WebhookDao webhookDao = (WebhookDao)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebhookDao>(){

            public WebhookDao doInTransaction() {
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.create(WebhookDao.class, new DBParam[]{new DBParam("LAST_UPDATED_USER", (Object)JiraWebHookListenerStore.this.userManager.getRemoteUsername()), new DBParam("URL", (Object)listener.getUrl()), new DBParam("LAST_UPDATED", (Object)new Date()), new DBParam("NAME", (Object)listener.getName()), new DBParam("FILTER", (Object)JqlFilterStoreUtils.getJqlFilter(listener)), new DBParam("REGISTRATION_METHOD", (Object)registrationMethod.toString()), new DBParam("ENABLED", (Object)true), new DBParam("EXCLUDE_ISSUE_DETAILS", (Object)listener.isExcludeBody())});
                webHookDao.setEvents((String[])Iterables.toArray((Iterable)listener.getEvents(), String.class));
                webHookDao.save();
                return webHookDao;
            }
        });
        return this.createWebHookListener(webhookDao);
    }

    public PersistentWebHookListener updateWebHook(final PersistentWebHookListener listener) throws IllegalArgumentException {
        return this.createWebHookListener((WebhookDao)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebhookDao>(){

            public WebhookDao doInTransaction() {
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, listener.getId().get());
                if (webHookDao == null) {
                    throw new IllegalArgumentException(JiraWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                webHookDao.setName(listener.getName());
                webHookDao.setUrl(listener.getUrl());
                webHookDao.setEvents(listener.getEvents().toArray(new String[listener.getEvents().size()]));
                webHookDao.setFilter(JqlFilterStoreUtils.getJqlFilter(listener));
                webHookDao.setExcludeIssueDetails(listener.isExcludeBody());
                webHookDao.setLastUpdatedUser(JiraWebHookListenerStore.this.userManager.getRemoteUsername());
                webHookDao.setLastUpdated(new Date());
                webHookDao.setEnabled(listener.isEnabled());
                webHookDao.save();
                return webHookDao;
            }
        }));
    }

    public Option<PersistentWebHookListener> getWebHook(final int id) {
        return (Option)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Option<PersistentWebHookListener>>(){

            public Option<PersistentWebHookListener> doInTransaction() {
                return Option.option((Object)JiraWebHookListenerStore.this.createWebHookListener((WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id)));
            }
        });
    }

    public void removeWebHook(final int id) throws IllegalArgumentException {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                WebhookDao webHookDao = (WebhookDao)JiraWebHookListenerStore.this.ao.get(WebhookDao.class, (Object)id);
                if (webHookDao == null) {
                    throw new IllegalArgumentException(JiraWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                JiraWebHookListenerStore.this.ao.delete(new RawEntity[]{webHookDao});
                return webHookDao;
            }
        });
    }

    public Collection<PersistentWebHookListener> getAllWebHooks() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Iterable)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Collection<WebhookDao>>(){

            public Collection<WebhookDao> doInTransaction() {
                return Arrays.asList(JiraWebHookListenerStore.this.ao.find(WebhookDao.class));
            }
        })), (Function)new Function<WebhookDao, PersistentWebHookListener>(){

            public PersistentWebHookListener apply(WebhookDao webhookDao) {
                return JiraWebHookListenerStore.this.createWebHookListener(webhookDao);
            }
        }));
    }

    private PersistentWebHookListener createWebHookListener(WebhookDao webhookDao) {
        int id = webhookDao.getID();
        String url = this.ensureStringNotNull(webhookDao.getUrl(), id, "url");
        String name = this.ensureStringNotNull(webhookDao.getName(), id, "name");
        String filter = this.ensureStringNotNull(webhookDao.getFilter(), id, "filter");
        String[] events = this.ensureNotNull(webhookDao.getEvents(), id, "events", new String[0]);
        String lastUpdatedUser = this.ensureStringNotNull(webhookDao.getLastUpdatedUser(), id, "lastUpdatedUser");
        Date lastUpdated = this.ensureNotNull(webhookDao.getLastUpdated(), id, "lastUpdated", new Date());
        return JqlFilterStoreUtils.persistentListenerBuilder(id).setUrl(url).setEnabled(webhookDao.isEnabled()).addWebHookIds(Arrays.asList(events)).setLastUpdated(lastUpdated).setLastUpdatedByUser(lastUpdatedUser).setListenerName(name).setExcludeBody(webhookDao.getExcludeIssueDetails()).setJqlFilter(filter).build();
    }

    private String ensureStringNotNull(String value, int id, String valueName) {
        return this.ensureNotNull(value, id, valueName, "");
    }

    private <T> T ensureNotNull(T value, int id, String valueName, T emptyValue) {
        if (value == null) {
            log.warn((Object)String.format("%s was NULL for webhook listener %d but shouldn't have been, defaulting to '%s'", valueName, id, emptyValue));
            return emptyValue;
        }
        return value;
    }
}

