/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.web;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.plugin.viewissue.web.CustomFieldModel;
import com.atlassian.jira.plugin.viewissue.web.DateFieldModelFactory;
import com.atlassian.jira.plugin.viewissue.web.FieldModel;
import com.atlassian.jira.plugin.viewissue.web.SystemFieldModel;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import webwork.action.Action;

public class FieldModelFactory {
    public static final String COMPOSED_BY_FIELDS = "composedByFields";
    private final DateFieldModelFactory dateFieldModelFactory;
    private final FieldLayoutManager fieldLayoutManager;

    public FieldModelFactory(FieldLayoutManager fieldLayoutManager, DateFieldModelFactory dateFieldModelFactory) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.dateFieldModelFactory = dateFieldModelFactory;
    }

    public List<FieldModel> getFieldModels(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        Action action = (Action)context.get("action");
        List fields = (List)context.getOrDefault(COMPOSED_BY_FIELDS, Lists.newArrayList());
        return fields.stream().map(field -> this.toModel((Field)field, issue, action)).collect(Collectors.toList());
    }

    public boolean hasRequestedFields(Map<String, Object> contextMap) {
        return contextMap.containsKey(COMPOSED_BY_FIELDS);
    }

    private FieldModel toModel(Field field, Issue issue, Action action) {
        if (this.dateFieldModelFactory.isDateSystemField(field)) {
            return this.dateFieldModelFactory.toModel(field, issue);
        }
        if (field instanceof CustomField) {
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem((OrderableField)((CustomField)field), issue);
            return new CustomFieldModel(fieldLayoutItem, issue, action);
        }
        return new SystemFieldModel(field);
    }

    private FieldLayoutItem getFieldLayoutItem(OrderableField field, Issue issue) {
        if (issue != null) {
            return this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(field);
        }
        return this.fieldLayoutManager.getFieldLayout().getFieldLayoutItem(field);
    }
}

