/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.web;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.viewissue.web.DateFieldModel;
import com.atlassian.jira.plugin.viewissue.web.DueDateFieldModel;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.DateFieldFormat;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;

public class DateFieldModelFactory {
    private final DateFieldFormat dateFieldFormat;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public DateFieldModelFactory(DateTimeFormatterFactory dateTimeFormaterFactory, DateFieldFormat dateFieldFormat, JiraAuthenticationContext jiraAuthenticationContext) {
        this.dateTimeFormatterFactory = dateTimeFormaterFactory;
        this.dateFieldFormat = dateFieldFormat;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public boolean isDateSystemField(Field field) {
        JiraDataType fieldType = JiraDataTypes.getFieldType((String)field.getId());
        return fieldType != null && fieldType.matches(JiraDataTypes.DATE);
    }

    public DateFieldModel toModel(Field field, Issue issue) {
        Timestamp date = this.getTimestampFromIssue(issue, field);
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterFactory.formatter().forLoggedInUser();
        if ("duedate".equals(field.getId())) {
            return this.createDueDateFieldModel(dateTimeFormatter, field, date);
        }
        return this.createDateTimeFieldModel(dateTimeFormatter, field, date);
    }

    private DateFieldModel createDateTimeFieldModel(DateTimeFormatter dateTimeFormatter, Field field, Timestamp dateTime) {
        String fieldHtml = dateTime != null ? StringEscapeUtils.escapeHtml((String)dateTimeFormatter.format((Date)dateTime)) : null;
        String iso8601 = StringEscapeUtils.escapeHtml((String)dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)dateTime));
        String title = StringEscapeUtils.escapeHtml((String)dateTimeFormatter.withStyle(DateTimeStyle.COMPLETE).format((Date)dateTime));
        return new DateFieldModel(field, fieldHtml, iso8601, title);
    }

    private DueDateFieldModel createDueDateFieldModel(DateTimeFormatter dateTimeFormatter, Field field, Timestamp dueDate) {
        String fieldHtml = dueDate != null ? StringEscapeUtils.escapeHtml((String)this.dateFieldFormat.format((Date)dueDate)) : null;
        String iso8601 = StringEscapeUtils.escapeHtml((String)dateTimeFormatter.withSystemZone().withStyle(DateTimeStyle.ISO_8601_DATE).format((Date)dueDate));
        String title = fieldHtml;
        DueDateFieldModel model = new DueDateFieldModel(field, fieldHtml, iso8601, title);
        model.name = this.jiraAuthenticationContext.getI18nHelper().getText("issue.field.due");
        return model;
    }

    private Timestamp getTimestampFromIssue(Issue issue, Field dateField) {
        String id = dateField.getId();
        if ("duedate".equals(id)) {
            return issue.getDueDate();
        }
        if ("created".equals(id)) {
            return issue.getCreated();
        }
        if ("resolutiondate".equals(id)) {
            return issue.getResolutionDate();
        }
        if ("updated".equals(id)) {
            return issue.getUpdated();
        }
        throw new IllegalArgumentException("Unsupported field: " + id);
    }
}

