/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink.rest;

import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.plugin.viewissue.issuelink.RemoteIssueLinkUtils;
import com.atlassian.jira.plugin.viewissue.issuelink.rest.LinkTypeBean;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="remoteIssueLink")
public class RemoteIssueLinkResource {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteIssueLinkResource.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SimpleLinkManager simpleLinkManager;
    private final RemoteIssueLinkService remoteIssueLinkService;
    private final PluginAccessor pluginAccessor;

    public RemoteIssueLinkResource(JiraAuthenticationContext jiraAuthenticationContext, SimpleLinkManager simpleLinkManager, RemoteIssueLinkService remoteIssueLinkService, PluginAccessor pluginAccessor) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.simpleLinkManager = simpleLinkManager;
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.pluginAccessor = pluginAccessor;
    }

    @GET
    @Path(value="/linkType")
    @Produces(value={"application/json"})
    public Response getIssueLinkTypes(@QueryParam(value="issueId") long issueId) {
        Map params = MapBuilder.newBuilder().add((Object)"issueId", (Object)issueId).toMap();
        JiraHelper helper = new JiraHelper(ExecutingHttpRequest.get(), null, params);
        List linkTypes = this.simpleLinkManager.getLinksForSection("create-issue-link-types", this.jiraAuthenticationContext.getUser(), helper);
        Collection<LinkTypeBean> beans = this.convertToLinkTypeBeans(linkTypes);
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="/render/{id}")
    @Produces(value={"text/html"})
    public Response getRemoteIssueLinkHtml(@PathParam(value="id") long id) {
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.getRemoteIssueLink(this.jiraAuthenticationContext.getUser(), Long.valueOf(id));
        if (!result.isValid()) {
            ErrorCollection errors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)result.getErrorCollection());
            Response.Status status = errors.getStatus() == null ? Response.Status.BAD_REQUEST : Response.Status.fromStatusCode((int)errors.getStatus());
            LOG.error("Failed to retrieve the remote issue link '{}': {}", (Object)id, (Object)errors.toString());
            return Response.status((Response.Status)status).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        LOG.debug("Successfully retrieved the remote issue link '{}'", (Object)id);
        try {
            String entity = RemoteIssueLinkUtils.getFinalHtml(result.getRemoteIssueLink(), this.pluginAccessor);
            return Response.ok((Object)entity).cacheControl(CacheControl.never()).build();
        }
        catch (Exception e) {
            LOG.error("Error occurred while generating final HTML for remote issue link: " + this.getExceptionMessagesForAllCauses(e));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).cacheControl(CacheControl.never()).build();
        }
    }

    private Collection<LinkTypeBean> convertToLinkTypeBeans(Collection<SimpleLink> linkTypes) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(linkTypes, (Function)new Function<SimpleLink, LinkTypeBean>(){

            public LinkTypeBean apply(SimpleLink from) {
                return new LinkTypeBean(from.getId(), from.getLabel(), from.getUrl(), (String)from.getParams().get("focused-field-name"));
            }
        }));
    }

    private String getExceptionMessagesForAllCauses(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.toString());
        for (e = e.getCause(); e != null; e = e.getCause()) {
            sb.append(" Caused by: ").append(e.toString());
        }
        return sb.toString();
    }
}

