/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.issuelink.IssueLinkRenderer;
import com.atlassian.jira.plugin.issuelink.IssueLinkRendererModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RemoteIssueLinkUtils {
    public static final String DEFAULT_RELATIONSHIP_I18N_KEY = "issuelinking.remote.link.relationship.default";

    private RemoteIssueLinkUtils() {
    }

    public static Map<String, List<IssueLinkContext>> convertToIssueLinkContexts(List<RemoteIssueLink> remoteIssueLinks, Long issueId, String baseUrl, I18nHelper i18n, PluginAccessor pluginAccessor) {
        HashMap contextsMap = Maps.newHashMap();
        for (RemoteIssueLink remoteIssueLink : remoteIssueLinks) {
            List<IssueLinkContext> contexts;
            String html;
            boolean requiresAsyncLoading;
            IssueLinkRendererModuleDescriptor descriptor = RemoteIssueLinkUtils.getIssueLinkRendererModuleDescriptor(pluginAccessor, remoteIssueLink.getApplicationType());
            IssueLinkRenderer issueLinkRenderer = null;
            try {
                issueLinkRenderer = (IssueLinkRenderer)descriptor.getModule();
                if (!issueLinkRenderer.shouldDisplay(remoteIssueLink)) continue;
                requiresAsyncLoading = issueLinkRenderer.requiresAsyncLoading(remoteIssueLink);
                html = descriptor.getInitialHtml(remoteIssueLink);
            }
            catch (Throwable t) {
                SafePluginPointAccess.handleException((Throwable)t, (ModuleDescriptor)descriptor, (Object)issueLinkRenderer);
                continue;
            }
            String relationship = StringUtils.defaultIfEmpty((String)remoteIssueLink.getRelationship(), (String)i18n.getText(DEFAULT_RELATIONSHIP_I18N_KEY));
            if (contextsMap.containsKey(relationship)) {
                contexts = (List)contextsMap.get(relationship);
            } else {
                contexts = Lists.newArrayList();
                contextsMap.put(relationship, contexts);
            }
            String deleteUrl = String.format(baseUrl + "/secure/DeleteRemoteIssueLink.jspa?id=%d&remoteIssueLinkId=%d", issueId, remoteIssueLink.getId());
            contexts.add(IssueLinkContext.newRemoteIssueLinkContext("remote-" + remoteIssueLink.getId(), deleteUrl, true, html, remoteIssueLink.getId(), requiresAsyncLoading));
        }
        return contextsMap;
    }

    public static String getFinalHtml(RemoteIssueLink remoteIssueLink, PluginAccessor pluginAccessor) {
        IssueLinkRendererModuleDescriptor descriptor = RemoteIssueLinkUtils.getIssueLinkRendererModuleDescriptor(pluginAccessor, remoteIssueLink.getApplicationType());
        try {
            return descriptor.getFinalHtml(remoteIssueLink);
        }
        catch (Error e) {
            SafePluginPointAccess.handleError((Error)e, (ModuleDescriptor)descriptor);
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    static IssueLinkRendererModuleDescriptor getIssueLinkRendererModuleDescriptor(PluginAccessor pluginAccessor, final String applicationType) {
        Option specific;
        List descriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(IssueLinkRendererModuleDescriptor.class);
        if (StringUtils.isNotBlank((String)applicationType) && (specific = Iterables.findFirst((Iterable)descriptors, (Predicate)SafePluginPointAccess.safe((Predicate)new Predicate<IssueLinkRendererModuleDescriptor>(){

            public boolean apply(IssueLinkRendererModuleDescriptor descriptor) {
                return descriptor.handlesApplicationType(applicationType);
            }
        }))).isDefined()) {
            return (IssueLinkRendererModuleDescriptor)specific.get();
        }
        return RemoteIssueLinkUtils.getDefaultLinkRendererModuleDescriptor(descriptors);
    }

    private static IssueLinkRendererModuleDescriptor getDefaultLinkRendererModuleDescriptor(List<IssueLinkRendererModuleDescriptor> descriptors) {
        Option defaultDescriptor = Iterables.findFirst(descriptors, (Predicate)SafePluginPointAccess.safe((Predicate)new Predicate<IssueLinkRendererModuleDescriptor>(){

            public boolean apply(IssueLinkRendererModuleDescriptor descriptor) {
                return descriptor.isDefaultHandler();
            }
        }));
        if (defaultDescriptor.isEmpty()) {
            throw new IllegalStateException("No default issue link renderer module descriptor found");
        }
        return (IssueLinkRendererModuleDescriptor)defaultDescriptor.get();
    }
}

