/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue.issuelink;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class IssueLinkContext {
    private final String htmlElementId;
    private final String html;
    private final String deleteUrl;
    private final boolean remote;
    private final Long id;
    private final boolean requiresAsyncLoading;
    private final Map<String, Object> map;

    private IssueLinkContext(String htmlElementId, String deleteUrl, boolean remote, String html, Long id, boolean requiresAsyncLoading, Map<String, Object> map) {
        this.htmlElementId = htmlElementId;
        this.deleteUrl = deleteUrl;
        this.remote = remote;
        this.html = html;
        this.id = id;
        this.requiresAsyncLoading = requiresAsyncLoading;
        this.map = map;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public String getHtmlElementId() {
        return this.htmlElementId;
    }

    public String getHtml() {
        return this.html;
    }

    public String getDeleteUrl() {
        return this.deleteUrl;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public Long getId() {
        return this.id;
    }

    public boolean isRequiresAsyncLoading() {
        return this.requiresAsyncLoading;
    }

    public static IssueLinkContext newRemoteIssueLinkContext(String htmlElementId, String deleteUrl, boolean remote, String html, Long id, boolean requiresAsyncLoading) {
        return new IssueLinkContext(htmlElementId, deleteUrl, remote, html, id, requiresAsyncLoading, Collections.emptyMap());
    }

    public static IssueLinkContext newLocalIssueLinkContext(String htmlElementId, String deleteUrl, boolean remote, Map<String, Object> map) {
        return new IssueLinkContext(htmlElementId, deleteUrl, remote, null, null, false, map);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLinkContext that = (IssueLinkContext)o;
        if (this.remote != that.remote) {
            return false;
        }
        if (this.deleteUrl != null ? !this.deleteUrl.equals(that.deleteUrl) : that.deleteUrl != null) {
            return false;
        }
        if (this.html != null ? !this.html.equals(that.html) : that.html != null) {
            return false;
        }
        if (this.htmlElementId != null ? !this.htmlElementId.equals(that.htmlElementId) : that.htmlElementId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.map != null ? !this.map.equals(that.map) : that.map != null);
    }

    public int hashCode() {
        int result = this.htmlElementId != null ? this.htmlElementId.hashCode() : 0;
        result = 31 * result + (this.html != null ? this.html.hashCode() : 0);
        result = 31 * result + (this.deleteUrl != null ? this.deleteUrl.hashCode() : 0);
        result = 31 * result + (this.remote ? 1 : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.map != null ? this.map.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("htmlElementId", (Object)this.htmlElementId).append("deleteUrl", (Object)this.deleteUrl).append("remote", this.remote).append("html", (Object)this.html).append("map", this.map).append("id", (Object)this.id).toString();
    }
}

